/*
 * Detalhes da ltima alterao:
 * 
 * $Author$
 * $Date$
 * $Revision$
 */
package csbase.exception;

/**
 * Representa uma exceo de configurao invlida.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ConfigurationException extends RuntimeException {
  /**
   * Constri uma exceo contendo a causa/exceo original.
   * 
   * @param exception A exceo original.
   */
  public ConfigurationException(Throwable exception) {
    super(exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   * 
   * @param exception A exceo original.
   * @param message A mensagem.
   */
  public ConfigurationException(Throwable exception, String message) {
    super(message, exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   * 
   * @param message A mensagem.
   */
  public ConfigurationException(String message) {
    super(message);
  }
}