/*
 * CommandNotificationData.java
 * 
 * $Author$ $Date$
 * $Revision$
 */
package csbase.logic;

/**
 * Classe que representa os dados de mensagem de comando em um SGA.
 * 
 * @author Bruno Oliveira Silvestre
 */
public abstract class CommandNotification extends Notification {

  /** Identificador do comando no SGA. */
  protected Object commandId;

  /** Descrio do comando no SGA. */
  protected String cmdDesc;

  /** Dica para auxiliar a identificao do algoritmo do comando */
  protected String tip;

  /** hora de incio */
  protected long startTime;

  /** servidor/n de execuo */
  protected String execHost;

  /** Identificador do projeto */
  private Object projectId;

  /**
   * Informaes sobre a finalizao do comando.
   */
  protected CommandFinalizationInfo finalizationInfo;

  /**
   * Retorna as informaes sobre a finalizao do comando.
   * 
   * @return finalizationInfo as informaes de finalizao.
   */
  public CommandFinalizationInfo getFinalizationInfo() {
    return finalizationInfo;
  }

  /**
   * Atribui as informaes sobre a finalizao do comando.
   * 
   * @param finalizationInfo as informaes de finalizao.
   */
  public void setFinalizationInfo(CommandFinalizationInfo finalizationInfo) {
    this.finalizationInfo = finalizationInfo;
  }

  /**
   * Definio da volatilidade da notificao.
   * 
   * @return Flag indicativo da volatilidade da notificao.
   */
  @Override
  public boolean isVolatile() {
    return false;
  }

  /**
   * Retorna a dica para auxiliar a identificao do algoritmo do comando.
   * 
   * @return a dica para auxiliar a identificao do algoritmo do comando
   */
  public String getTip() {
    return tip;
  }

  /**
   * Retorna a descrio do comando.
   * 
   * @return O objeto correspontente a descrio do comando.
   */
  public String getCmdDesc() {
    return cmdDesc;
  }

  /**
   * Retorna o identificador do comando.
   * 
   * @return O identificador do comando.
   */
  public Object getCommandId() {
    return commandId;
  }

  /**
   * Retorna a hora de incio da execuo do comando.
   * 
   * @return o identificador
   */
  public long getStartTime() {
    return startTime;
  }

  /**
   * Retorna servidor / n de execuo
   * 
   * @return o identificador
   */
  public Object getExecHost() {
    return execHost;
  }

  /**
   * Identificador do projeto sobre o qual o comando  executado.
   * 
   * @return identificador do projeto sobre o qual o comando  executado
   */
  public Object getProjectId() {
    return projectId;
  }

  /**
   * Retorna string que representa o status de finalizao do comando.
   * 
   * @return String de status de finalizao do comando.
   */
  protected abstract String getStatusString();

  /**
   * Constri o evento de comando.
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param commandId identificador do comando.
   * @param cmdDesc descrio do comando.
   * @param tip Dica para auxiliar a identificao do algoritmo do comando.
   * @param startTime Hora de incio.
   * @param execHost Servidor de execuo.
   * @param projectId identificador do projeto.
   * @param finalizationInfo Informaes sobre a finalizao do comando.
   */
  public CommandNotification(String sender, Object commandId,
    String cmdDesc, String tip, long startTime, String execHost,
    Object projectId, CommandFinalizationInfo finalizationInfo) {
    super(sender);
    this.commandId = commandId;
    this.cmdDesc = cmdDesc;
    this.tip = tip;
    this.startTime = startTime;
    this.execHost = execHost;
    this.projectId = projectId;
    this.finalizationInfo = finalizationInfo;
  }
}
