package csbase.logic;

/**
 * Classe responsvel pelo estado de um comando em execuo.
 */
public enum CommandStatus {
  /** Aguardando sua vez no escalonador. */
  SCHEDULED,
  /** O comando j est no SGAService, mas est em fase de inicializao. */
  INIT,
  /** Transferindo arquivos via CSFS. */
  UPLOADING,
  /** Em execuo. */
  EXECUTING,
  /** Trazendo arquivos de volta para o servidor, via CSFS. */
  DOWNLOADING,
  /** Terminado. */
  FINISHED,
  /**
   * Ocorreu uma falha no sistema que impossibilitou recuperar os dados do
   * comando.
   */
  SYSTEM_FAILURE;
}
