/**
 * $Id$
 */

package csbase.logic;

/**
 * Representa o evento de renomear um arquivo na rvore do projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectFileRenamedEvent extends ProjectEvent {
  /**
   * o caminho do arquivo com o nome antigo.
   */
  private String[] path;
  /**
   * O novo nome.
   */
  private String newName;
  /**
   * O nome antigo.
   */
  private String newType;
  /**
   * O arquivo renomeado.
   */
  private ClientProjectFile file;

  /**
   * Retorna o caminho do arquivo com o nome antigo.
   * 
   * @return O caminho do arquivo com o nome antigo.
   */
  public String[] getPath() {
    return path;
  }

  /**
   * Retorna o novo nome do arquivo como resultado do evento ocorrido.
   * 
   * @return O novo nome do arquivo
   */
  public String getNewName() {
    return newName;
  }

  /**
   * Retorna o novo tipo do arquivo como resultado do evento ocorrido.
   * 
   * @return O novo tipo do arquivo
   */
  public String getNewType() {
    return newType;
  }

  /**
   * Atribui o arquivo cujo nome foi alterado.
   * 
   * @param file O arquivo cujo nome foi alterado.
   */
  public void setFile(ClientProjectFile file) {
    this.file = file;
  }

  /**
   * Retorna o arquivo cujo nome foi alterado.
   * 
   * @return O arquivo cujo nome foi alterado.
   */
  public ClientProjectFile getFile() {
    return file;
  }

  /**
   * Cria uma instncia de <code>ProjectEvent</code> para o evento de renomear
   * um arquivo na rvore de um projeto.
   * 
   * @param projectId o identificador do projeto
   * @param path O caminho do arquivo com o nome antigo
   * @param newName O novo nome do arquivo
   * @param newType O novo tipo do arquivo
   */
  public ProjectFileRenamedEvent(Object projectId, String[] path,
    String newName, String newType) {
    event = NEW_FILE_NAME;
    this.projectId = projectId;
    this.path = path;
    this.newName = newName;
    this.newType = newType;
  }
}
