package csbase.logic;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

import csbase.remote.ClientRemoteLocator;

/**
 * Permisso que possibilita a um tipo de usurio especial, chamado de
 * super-usurio, delegar um login de um outro usurio especificado por ele sem
 * necessidade de entrada de senha.
 */
public class SuperUserPermission extends ChoicePermission {
  public SuperUserPermission() {
    super();
  }

  public SuperUserPermission(String name, String description, Map attributes) {
    super(name, description, attributes);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<String, Object> getDomain() {
    Map<String, Object> map = new LinkedHashMap<String, Object>();
    map.put("IAS_ROLES", Boolean.TRUE);
    return map;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<String, Object> getRange(String key) throws Exception {
    Collection<Role> roles =
      ClientRemoteLocator.administrationService.getAllRoles();
    LinkedHashMap<String, Object> rolesMap =
      new LinkedHashMap<String, Object>();
    for (Role r : roles) {
      rolesMap.put(r.getName(), r.getId());
    }
    return rolesMap;
  }
}
