/**
 * $Id$
 */

package csbase.logic;

/**
 * Representa o evento que indica que a rvore do projeto foi reconstruda.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class TreeChangedEvent extends ProjectEvent {
  /**
   * A nova rvore do projeto
   */
  private ClientProjectFile newTree;

  /**
   * Retorna a nova rvore do projeto.
   * 
   * @return A nova rvore do projeto.
   */
  public ClientProjectFile getNewTree() {
    return newTree;
  }

  /**
   * Construtor.
   * 
   * @param projectId o identificador do projeto
   * @param newTree a nova rvore do projeto
   */
  TreeChangedEvent(Object projectId, ClientProjectFile newTree) {
    event = TREE_CHANGED;
    this.projectId = projectId;
    this.newTree = newTree;
  }
}
