/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.HiddenParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.logic.algorithms.parsers.ParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.Collections;
import java.util.List;

public class HiddenParameterParser
extends ParameterParser
implements ParameterFactory {
    static final String HIDDEN_PARAMETER_ELEMENT = "oculto";
    private static final String HIDDEN_PARAMETER_ELEMENT_VALUE_ATTRIBUTE = "valor";

    public HiddenParameter createParameter(XmlParser parser, String defaultCommandLinePattern, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String name = parser.extractAttributeValue("nome");
        String value = parser.extractAttributeValue(HIDDEN_PARAMETER_ELEMENT_VALUE_ATTRIBUTE);
        parser.checkAttributes();
        String commandLinePattern = this.loadCommandLinePattern(parser, defaultCommandLinePattern);
        if (commandLinePattern == null) {
            throw new ParseException("N\u00e3o \u00e9 poss\u00edvel criar um par\u00e2metro oculto com formato no comando vazio.\nPar\u00e2metro: {0}\nValor: {1}.", name, value);
        }
        return new HiddenParameter(name, value, commandLinePattern);
    }

    @Override
    public List<Class<? extends Parameter>> getParameterTypes() {
        return Collections.singletonList(HiddenParameter.class);
    }
}

