/*
 * Detalhes da ltima alterao:
 *
 * $Author$
 * $Date$
 * $Revision$
 */
package csbase.exception;

import java.text.MessageFormat;

/**
 * A classe <code>CSBaseException</code> representa uma exceo do tipo
 * "checked". Esse tipo de exceo  lanada sempre que o tratamento de um
 * erro deve ser realizado pelo invocador imediato do mtodo onde o erro
 * ocorreu.
 */
public class CSBaseException extends Exception {
  /**
   * Constri uma exceo sem descrio nem causa associadas.
   */
  public CSBaseException() {
    super();
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   *
   * @param message a descrio do erro
   */
  public CSBaseException(String message) {
    super(message);
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   *
   * @param pattern um padro com a descrio do erro
   * @param arguments os argumentos que sero formatados na descrio do erro
   *
   * @see MessageFormat
   */
  public CSBaseException(String pattern, Object... arguments) {
    super(MessageFormat.format(pattern, arguments));
  }

  /**
   * Constri uma exceo contendo a causa/exceo original.
   *
   * @param exception a exceo original
   */
  public CSBaseException(Throwable exception) {
    super(exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   *
   * @param message a descrio do erro
   * @param exception a exceo original
   */
  public CSBaseException(String message, Throwable exception) {
    super(message, exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente e a
   * causa/exceo original.
   *
   * @param pattern um padro com a descrio do erro
   * @param arguments os argumentos que sero formatados na descrio do erro
   * @param exception a exceo original
   *
   * @see MessageFormat
   */
  public CSBaseException(
    String pattern, Object[] arguments, Throwable exception) {
    super(MessageFormat.format(pattern, arguments), exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente e a
   * causa/exceo original.
   *
   * @param exception a exceo original
   * @param pattern um padro com a descrio do erro
   * @param arguments os argumentos que sero formatados na descrio do erro
   *
   * @see MessageFormat
   */
  public CSBaseException(Throwable exception, String pattern, Object... arguments) {
    super(MessageFormat.format(pattern, arguments), exception);
  }
}
