/*
 * @(#)MDigest.java 1.00 19/03/02
 */
package csbase.logic;

import java.security.DigestException;
import java.security.MessageDigest;

/**
 * <code>MDigest</code>  uma classe esttica que utiliza as funcionalidades da
 * classe java.security.MessageDigest para gerar o hash MD5 de mensagens. O hash
 *  gerado como o string de um nmero hexadecimal.
 * 
 * @author Marcus Leal
 * @version $Revision$
 */
public class MDigest {
  public static void main(String[] args) {
    try {
      System.out.println("O hash MD5 de " + args[0] + " e' "
        + getDigest(args[0]));
    }
    catch (Exception e) {
      System.err.println("Exception: " + e.toString());
    }
  }

  /**
   * Gera o message digest para os valores fornecidos.
   * 
   * @param s String.
   * 
   * @return o digest representado atravs de uma string em hexadecimal.
   * 
   * @throws DigestException em caso de erro.
   */
  public static String getDigest(String s) throws DigestException {
    return getDigest(s.getBytes());
  }

  /**
   * Gera o message digest para os valores fornecidos.
   * 
   * @param b array de bytes.
   * 
   * @return o digest representado atravs de uma string em hexadecimal.
   *
   * @throws DigestException em caso de erro.
   */
  public static String getDigest(byte[] b) throws DigestException {
    if (b == null) {
      throw new IllegalArgumentException("b == null");
    }
    try {
      // Algoritmo MD5 
      MessageDigest mac = MessageDigest.getInstance("MD5");
      mac.update(b);
      return convertToHexString(mac.digest());
    }
    catch (Exception e) {
      throw new DigestException();
    }
  }

  public static String convertToHexString(byte[] bytes) {
    int size = bytes.length;
    StringBuilder buffer = new StringBuilder();
    for (int i = 0; i < size; i++) {
      int x = bytes[i];

      // byte pode ser signed ou unsigned
      if (x < 0) {
        x += 256;
      }
      String tmp = Integer.toHexString(x);

      // adiciona um "0" em hexs com apenas um algorismo ("1"->"01").
      if (tmp.length() == 1) {
        buffer.append('0');
      }
      buffer.append(tmp);
    }
    return buffer.toString();
  }
}
