/*
 * $Id$
 */
package csbase.logic.algorithms.xml.algorithmspack;

/**
 * 
 * Classe utilitria relacionada a leitura e escrita de um pacote de algoritmos
 * descrito atravs de um arquivo xml.
 * 
 */
public class XmlAlgorithmsPackUtils {
  /** Tag do elemento raiz do arquivo xml de algoritmos */
  final static public String ALGORITHMS_TAG = "algoritmos";

  /** Tag do elemento algoritmo */
  final static public String ALGORITHM_TAG = "algoritmo";

  /** Tag do elemento que especifica o id do algoritmo */
  final static public String ALGORITHM_ID_TAG = "id";

  /** Tag do elemento que especifica o nome do algoritmo */
  final static public String ALGORITHM_NAME_TAG = "nome";

  /** Tag do elemento que especifica a descrio do algoritmo ou da verso */
  final static public String DESCRIPTION_TAG = "descricao";

  /**
   * Tag do elemento que especifica as propriedades do algoritmo ou de uma
   * verso
   */
  final static public String PROPERTIES_TAG = "propriedades";

  /** Tag do elemento que especifica as verses do algoritmo */
  final static public String VERSIONS_TAG = "versoes";

  /** Tag do elemento que especifica as categorias do algoritmo */
  final static public String CATEGORIES_TAG = "categorias";

  /**
   * Tag do elemento que especifica uma propriedade do algoritmo ou de uma
   * verso
   */
  final static public String PROPERTY_TAG = "propriedade";

  /** Tag do elemento que especifica uma verso do algoritmo */
  final static public String VERSION_TAG = "versao";

  /** Tag do elemento que especifica uma categoria do algoritmo */
  final static public String CATEGORY_TAG = "categoria";

  /** Atributo do elemento que especifica o nome da propriedade */
  final static public String PROPERTY_NAME_ATTR = "nome";

  /** Atributo do elemento que especifica o valor da propriedade */
  final static public String PROPERTY_VALUE_ATTR = "valor";

  /** Atributo do elemento que especifica o valor de major de uma verso */
  final static public String VERSION_MAJOR_ATTR = "major";

  /** Atributo do elemento que especifica o valor de minor de uma verso */
  final static public String VERSION_MINOR_ATTR = "minor";

  /** Atributo do elemento que especifica o valor de patch de uma verso */
  final static public String VERSION_PATCH_ATTR = "patch";

  /** Atributo do elemento que especifica o nome da categoria do algoritmo */
  final static public String CATEGORY_NAME_ATTR = "nome";

}
