/**
 * $Id: Status.java 141063 2013-05-16 15:46:28Z fpina $
 */
package csbase.logic.diagnosticservice;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Representa o estado de um recurso.
 * 
 * @author Tecgraf
 */
public class Status implements Serializable {
  /**
   * Nome do recurso monitorado.
   */
  private String resourceName;

  /**
   * O cdigo do estado.
   */
  private StatusCode code;
  /**
   * O timestamp associado ao estado.
   */
  private Date timestamp;
  /**
   * Lista com os estados das validaes.
   */
  private ValidationStatus[] validationStatusList;
  /**
   * Propriedades da monitorao do recurso
   */
  private List<ResourceProperty> properties;

  /**
   * Construtor.
   * 
   * @param resourceName nome do recurso
   * @param code cdigo do estado
   * @param validationStatuses lista de {@link ValidationStatus}
   * @param properties lista de parmetros
   */
  public Status(String resourceName, StatusCode code,
    ValidationStatus[] validationStatuses, List<ResourceProperty> properties) {
    this.resourceName = resourceName;
    this.code = code;
    this.timestamp = new Date();
    this.properties = properties;
    if (validationStatuses == null) {
      this.validationStatusList = new ValidationStatus[0];
    }
    else {
      this.validationStatusList = validationStatuses;
    }
  }

  /**
   * Construtor.
   * 
   * @param resourceName nome do recurso
   * @param code cdigo do estado
   */
  public Status(String resourceName, StatusCode code) {
    this(resourceName, code, null, null);
  }

  /**
   * Nome do recurso monitorado
   * 
   * @return o nome do recurso
   */
  public String getResourceName() {
    return resourceName;
  }

  /**
   * O cdigo do estado da monitorao do recurso.
   * 
   * @return o estado da monitorao
   */
  public StatusCode getCode() {
    return code;
  }

  /**
   * Obtm o horrio da ltima monitorao efetuada sobre o recurso.
   * 
   * @return o horrio da ltima monitorao
   */
  public Date getTimestamp() {
    return timestamp;
  }

  /**
   * Obtm a lista com os estados de cada validao efetuada sobre o recurso.
   * 
   * @return a lista de todas as validaes aplicadas sobre o recurso.
   */
  public ValidationStatus[] getValidationStatusList() {
    return validationStatusList;
  }

  /**
   * A lista das propriedades usadas na monitorao do recurso.
   * 
   * @return as propriedades usadas na monitorao do recurso.
   */
  public List<ResourceProperty> getProperties() {
    return properties;
  }

  /**
   * O nome do recurso monitorado
   * 
   * @param name o novo nome
   */
  public void setName(String name) {
    this.resourceName = name;
  }
}
