/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.exception.CSBaseException;
import csbase.logic.MonitoredServer;
import csbase.logic.MonitoredServerListener;
import csbase.logic.ServerManagerData;
import csbase.logic.ServerMonitor;
import csbase.logic.ServerURI;
import csbase.logic.Session;
import csbase.logic.User;
import csbase.remote.RemoteObserver;
import csbase.remote.ServerEntryPoint;
import csbase.remote.ServiceInterface;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Set;

public class ServerManager {
    private ServerManagerData serverManagerData;

    protected ServerManager(boolean sharedServerData) {
        this(sharedServerData, true);
    }

    protected ServerManager(boolean sharedServerData, boolean verbose) {
        this.serverManagerData = !sharedServerData ? new ServerManagerData() : ServerManagerData.getInstance();
        this.serverManagerData.setVerbose(verbose);
    }

    protected ServerManager() {
        this(true);
    }

    public void setVerbose(boolean verbose) {
        this.serverManagerData.setVerbose(verbose);
        this.getMonitor().setVerbose(verbose);
    }

    public final boolean isAlive(ServerURI serverURI) {
        return this.getMonitoredServer(serverURI).isAlive();
    }

    public final boolean isAlive() {
        return this.getMonitoredServer(this.getDefaultURI()).isAlive();
    }

    public final void addCommonListener(MonitoredServerListener l) {
        this.serverManagerData.addCommonListener(l);
    }

    public final void deleteCommonListener(MonitoredServerListener l) {
        this.serverManagerData.deleteCommonListener(l);
    }

    public final void addListener(ServerURI serverURI, MonitoredServerListener l) {
        this.getMonitoredServer(serverURI).addListener(l);
    }

    public final void deleteListener(ServerURI serverURI, MonitoredServerListener l) {
        this.getMonitoredServer(serverURI).deleteListener(l);
    }

    public final void addListener(MonitoredServerListener l) {
        this.getMonitoredServer(this.getDefaultURI()).addListener(l);
    }

    public final void deleteListener(MonitoredServerListener l) {
        this.getMonitoredServer(this.getDefaultURI()).deleteListener(l);
    }

    public void addServer(MonitoredServer monitoredServer) {
        this.serverManagerData.addServer(monitoredServer);
    }

    private void removeServer(ServerURI sURI) {
        this.serverManagerData.removeServer(sURI);
    }

    private MonitoredServer getMonitoredServer(ServerURI uri) {
        return this.serverManagerData.getMonitoredServer(uri);
    }

    public final boolean isMonitored(ServerURI serverURI) {
        return this.serverManagerData.isMonitored(serverURI);
    }

    public ServerMonitor getMonitor(ServerURI uri) {
        return this.getMonitoredServer((ServerURI)uri).monitor;
    }

    public ServerMonitor getMonitor() {
        return this.getMonitoredServer((ServerURI)this.getDefaultURI()).monitor;
    }

    public ServerEntryPoint getServer(ServerURI uri) {
        return this.getMonitoredServer((ServerURI)uri).monitor.getServer();
    }

    public ServerEntryPoint getServer() {
        return this.getMonitoredServer((ServerURI)this.getDefaultURI()).monitor.getServer();
    }

    public Set<ServerURI> getManagedServers() {
        return this.serverManagerData.getManagedServers();
    }

    public final boolean performLookup(ServerURI uri) {
        return this.getMonitoredServer((ServerURI)uri).monitor.lookup();
    }

    public final boolean performLookup() {
        return this.getMonitoredServer((ServerURI)this.getDefaultURI()).monitor.lookup();
    }

    protected boolean validate(ServerURI uri) throws CSBaseException, RemoteException {
        return this.getMonitoredServer(uri).validate();
    }

    protected boolean validate() throws CSBaseException, RemoteException {
        return this.getMonitoredServer(this.getDefaultURI()).validate();
    }

    public Session getSession(ServerURI uri) {
        return this.getMonitoredServer((ServerURI)uri).session;
    }

    public Session getSession() {
        return this.getMonitoredServer((ServerURI)this.getDefaultURI()).session;
    }

    public void invalidate(ServerURI serverURI) {
        this.getMonitoredServer(serverURI).invalidate();
    }

    public void invalidate() {
        this.invalidate(this.getDefaultURI());
    }

    public final void setDefaultServer(ServerURI serverURI) {
        if (serverURI == null) {
            throw new IllegalArgumentException("serverURI == null");
        }
        if (!this.isMonitored(serverURI)) {
            throw new IllegalStateException(MessageFormat.format("Servidor {0} n\u00e3o est\u00e1 na monitora\u00e7\u00e3o", serverURI));
        }
        this.serverManagerData.setDefaultServer(serverURI);
    }

    public final ServerURI getDefaultURI() {
        return this.serverManagerData.getDefaultURI();
    }

    public final String getServerPath() {
        return this.getDefaultURI().getHostAndPort();
    }

    protected void setSystemName(ServerURI sURI, String systemName) {
        this.getMonitoredServer(sURI).setSystemName(systemName);
    }

    public final boolean isDefault(ServerURI sURI) {
        return this.getMonitoredServer(sURI).isDefault();
    }

    public Thread getServerLookupThread(ServerURI serverURI) {
        return this.getMonitor(serverURI).getServerLookupThread();
    }

    public Thread getServerLookupThread() {
        return this.getMonitor(this.getDefaultURI()).getServerLookupThread();
    }

    public final boolean addObserver(ServerURI serverURI, String serviceName, RemoteObserver observer, Object arg) {
        return this.getMonitoredServer(serverURI).addObserver(serviceName, observer, arg);
    }

    public final boolean addObserver(String serviceName, RemoteObserver observer, Object arg) {
        return this.addObserver(this.getDefaultURI(), serviceName, observer, arg);
    }

    public final synchronized void deleteObserver(ServerURI serverURI, String serviceName, RemoteObserver observer, Object arg) {
        this.getMonitoredServer(serverURI).deleteObserver(serviceName, observer, arg);
    }

    public final synchronized void deleteObserver(String serviceName, RemoteObserver observer, Object arg) {
        this.deleteObserver(this.getDefaultURI(), serviceName, observer, arg);
    }

    protected final synchronized void removeObservers(ServerURI serverURI) {
        this.getMonitoredServer(serverURI).removeObservers();
    }

    protected final void removeObservers() {
        this.removeObservers(this.getDefaultURI());
    }

    public final void logout(ServerURI serverURI, boolean flush) {
        if (flush) {
            this.removeServer(serverURI);
        } else {
            this.getMonitoredServer(serverURI).logout();
        }
    }

    public final void logout(boolean flush) {
        this.logout(this.getDefaultURI(), flush);
    }

    public void shutdown() {
        this.serverManagerData.shutdown();
        User.registerLogout();
    }

    public final boolean login(ServerURI serverURI) throws CSBaseException, RemoteException {
        return this.getMonitoredServer(serverURI).login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doLogin(ServerURI serverURI) throws CSBaseException, RemoteException {
        MonitoredServer monitoredServer = this.getMonitoredServer(serverURI);
        boolean validated = false;
        try {
            validated = monitoredServer.login();
        }
        finally {
            if (!validated) {
                this.removeServer(serverURI);
            } else {
                monitoredServer.getMonitor().startMonitoring();
            }
        }
        return validated;
    }

    public final <T> T getService(Class<T> serviceClass, ServerURI serverURI) throws RemoteException {
        MonitoredServer mServer = null;
        if (serverURI == null) {
            throw new IllegalArgumentException("serverURI == null");
        }
        mServer = this.getMonitoredServer(serverURI);
        for (ServiceInterface s : mServer.services.values()) {
            if (!serviceClass.isInstance(s)) continue;
            return serviceClass.cast(s);
        }
        return null;
    }

    public final <T> T getService(Class<T> serviceClass) throws RemoteException {
        return this.getService(serviceClass, this.getDefaultURI());
    }
}

