/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.AbstractEnumerationParameterParser;
import csbase.logic.algorithms.parsers.EnumerationListParameterParser;
import csbase.logic.algorithms.parsers.EnumerationParameterParser;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.ArrayList;
import java.util.List;

public class EnumerationParameterFactory
implements ParameterFactory {
    public static final String ENUMERATION_PARAMETER_ELEMENT = "enumeracao";
    protected static final String ENUMERATION_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE = "selecao_multipla";
    protected static final boolean ENUMERATION_PARAMETER_ELEMENT_MULTIPLE_SELECTION_DEFAULT_VALUE = false;
    private EnumerationListParameterParser enumListParser;
    private EnumerationParameterParser enumParser = new EnumerationParameterParser();

    public EnumerationParameterFactory() {
        this.enumListParser = new EnumerationListParameterParser();
    }

    @Override
    public Parameter<?> createParameter(XmlParser parser, String commandLinePattern, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        boolean isMultipleSelection = parser.extractAttributeValueAsBoolean(ENUMERATION_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE, false);
        AbstractEnumerationParameterParser enumerationParser = isMultipleSelection ? this.enumListParser : this.enumParser;
        return enumerationParser.createParameter(parser, commandLinePattern, group, configurator);
    }

    @Override
    public List<Class<? extends Parameter>> getParameterTypes() {
        ArrayList<Class<? extends Parameter>> types = new ArrayList<Class<? extends Parameter>>();
        types.addAll(this.enumParser.getParameterTypes());
        types.addAll(this.enumListParser.getParameterTypes());
        return types;
    }
}

