/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.serializer;

import csbase.exception.ConfigurationException;
import csbase.exception.ParseException;
import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowAlgorithmParser;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.serializer.IAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerException;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerIOException;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FlowAlgorithmConfigurationSerializer
implements IAlgorithmConfigurationSerializer {
    @Override
    public AlgorithmConfigurator read(InputStream input) throws AlgorithmConfigurationSerializerParseException, AlgorithmConfigurationSerializerIOException, AlgorithmConfigurationSerializerException, AlgorithmNotFoundException {
        try {
            Flow flow = new FlowAlgorithmParser().read(input);
            return new FlowAlgorithmConfigurator(flow);
        }
        catch (ConfigurationException e) {
            throw new AlgorithmConfigurationSerializerException(e);
        }
        catch (ParseException e) {
            throw new AlgorithmConfigurationSerializerParseException(e);
        }
        catch (IOException e) {
            throw new AlgorithmConfigurationSerializerIOException(e);
        }
    }

    @Override
    public void write(AlgorithmConfigurator configurator, OutputStream output) throws AlgorithmConfigurationSerializerException {
        if (configurator.getConfiguratorType() != AlgorithmConfigurator.ConfiguratorType.FLOW) {
            throw new IllegalArgumentException("O configurador deve ser do tipo FlowAlgorithmConfigurator");
        }
        FlowAlgorithmConfigurator flowConfigurator = (FlowAlgorithmConfigurator)configurator;
        try {
            new FlowAlgorithmParser().write(output, flowConfigurator.getFlow());
        }
        catch (Exception e) {
            throw new AlgorithmConfigurationSerializerException(e);
        }
    }
}

