package csbase.exception;

import java.text.MessageFormat;

/**
 * A classe <code>OperationFailureException</code> representa uma falha
 * durante a execuo de uma operao.  uma exceo do tipo "checked",
 * portanto deve ser necessariamente tratada pelo chamador imediato do mtodo
 * que a lanou.
 */
public class OperationFailureException extends CSBaseException {
/**
   * Constri uma exceo sem descrio nem causa associadas.
   */
  public OperationFailureException() {
    super();
  }

/**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param message a descrio do erro
   */
  public OperationFailureException(String message) {
    super(message);
  }

/**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param pattern um padro com a descrio do erro
   * @param arguments os argumentos que sero formatados na descrio do erro
   *
   * @see MessageFormat

   */
  public OperationFailureException(String pattern, Object... arguments) {
    super(pattern, arguments);
  }

/**
   * Constri uma exceo contendo a causa/exceo original.
   * 
   * @param exception a exceo original
   */
  public OperationFailureException(Throwable exception) {
    super(exception);
  }

/**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   * 
   * @param message a descrio do erro
   * @param exception a exceo original
   */
  public OperationFailureException(String message, Throwable exception) {
    super(message, exception);
  }
}
