package csbase.logic;

import java.io.Serializable;

/**
 * Interface para ser implementada por todas as classes que  representem para o
 * cliente uma informao remota a ser monitorada. Exemplo:  SGASet e
 * AlgorithmSet.
 */
public interface MonitoringSet extends Serializable {
  /**
   * Mtodo para comparar um MonitoringSet com outro.
   * @param set o MonitoringSet a ser comparado.
   *
   * @return .
   */
  public boolean equals(MonitoringSet set);

  /**
   * Mtodo que retorna um String identificador do MonitoringSet.
   *
   * @return .
   */
  public String getKey();
}
