/*
 * $Id$
 */
package csbase.logic.algorithms;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;

/**
 * Essa classe representa um pacote de algoritmos.
 * 
 */
public class AlgorithmsPack implements Serializable {
  /** Lista de algoritmos provenientes do pacote de algoritmos. */
  private List<AlgorithmInfo> algorithms;

  /**
   * Atribui a lista de algoritmos provenientes do pacote de algoritmos.
   * 
   * @param algorithms lista de algoritmos
   */
  public void setAlgorithms(List<AlgorithmInfo> algorithms) {
    this.algorithms = algorithms;
  }

  /**
   * Retorna a lista de algoritmos provenientes do pacote de algoritmos.
   * 
   * @return algorithms a lista de algoritmos do pacote de algoritmos
   */
  public List<AlgorithmInfo> getAlgorithms() {
    return algorithms;
  }

  /**
   * Obtm o nmero de algoritmos do pacote de algoritmos.
   * 
   * @return o nmero de algoritmos do pacote de algoritmos
   */
  public int getSize() {
    return algorithms.size();
  }

  /**
   * Adiciona um algoritmo ao pacote de algoritmos.
   * 
   * @param algoInfo Algoritmo a ser adicionado.
   */
  public void addAlgorithm(AlgorithmInfo algoInfo) {
    if (algorithms == null) {
      algorithms = new Vector<AlgorithmInfo>();
    }
    algorithms.add(algoInfo);
  }

}
