package csbase.logic.algorithms.parameters;

import java.util.List;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;

/**
 * Mtodo que determina o maior valor de uma lista.
 */
public final class ListMaxExpressionFunction extends ListExpressionFunction {

  /**
   * Construtor.
   */
  public ListMaxExpressionFunction() {
    super("list_max", new Class[] {});
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Object doOperation(List<?> values, Object... arguments)
    throws ExpressionFunctionExecutionException {
    if (values == null) {
      throw new ExpressionFunctionExecutionException("A lista est vazia.");
    }
    double maxValue = Double.MIN_VALUE;
    for (Object value : values) {
      double doubleValue = Double.parseDouble(value.toString());
      if (doubleValue > maxValue) {
        maxValue = doubleValue;
      }
    }
    return maxValue;
  }
}
