/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationSuccess;

/**
 * Validador de {@link csbase.logic.algorithms.parameters.BooleanParameter
 * Parmetro do Tipo Booleano}.
 * 
 * @author lmoreira
 */
public final class BooleanParameterValidator extends
  SimpleParameterValidator<Boolean> {
  /**
   * Cria um Validador.
   */
  public BooleanParameterValidator() {
    super(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Validation validateValue(SimpleParameter<?> parameter, Boolean value,
    ValidationContext context) {
    if (parameter == null) {
      throw new IllegalArgumentException("O parmetro parameter est nulo.");
    }
    if (value == null) {
      throw new IllegalArgumentException("O parmetro value est nulo.");
    }
    return new ValidationSuccess();
  }
}
