package csbase.logic.algorithms.parsers;

import static csbase.logic.algorithms.parsers.InputURLParameterParser.INPUT_URL_PARAMETER_ELEMENT;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.InputURLListParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;

/**
 * <p>
 * Analisador de {@link InputURLListParameter}.
 * </p>
 *
 * <p>
 * Este parser l os atributos de parmetros do tipo "url de entrada" mltiplo.
 * O elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link InputURLListParameter}.
 * </p>
 */
public class InputURLListParameterParser extends
  AbstractURLParameterParser<InputURLListParameter> {

  /**
   * {@inheritDoc}
   */
  @Override
  protected InputURLListParameter createURLParameter(
    ParsedSimpleParameter definition, String name, String label,
    String description, boolean isOptional, boolean isVisible,
    String commandLinePattern, String[] types, String localization,
    FileParameterMode mode, FileURLValue defaultValue,
    FileParameterPipeAcceptance usesPipe,
    EnumSet<URLProtocol> allowedProtocols) throws ParseException {

    boolean mustSort = definition.getAttributeValue(MUST_SORT_ATTRIBUTE);

    List<FileURLValue> defaultValues =
      defaultValue == null ? null : Collections.singletonList(defaultValue);
    return new InputURLListParameter(name, label, description, defaultValues,
      isOptional, isVisible, commandLinePattern, localization, types, mode,
      mustSort, allowedProtocols);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterStructure<InputURLListParameter> getParameterStructure() {
    ParameterStructure<InputURLListParameter> urlStructure =
      getURLStructure(INPUT_URL_PARAMETER_ELEMENT, InputURLListParameter.class);
    urlStructure.addAttribute(
      new BooleanAttribute(MUST_SORT_ATTRIBUTE, MUST_SORT_DEFAULT_VALUE));
    return urlStructure;
  }

}
