package csbase.logic.algorithms.parsers.elements.attributes;

import csbase.exception.ParseException;

/**
 * Atributo do tipo array de Strings.
 */
public class ArrayAttribute extends AbstractElementAttribute<String[]>
  implements StringToValueConverter<String[]> {

  /**
   * Construtor.
   *
   * @param name nome do atributo.
   * @param isOptional indicativo de opcionalidade.
   * @param defaultValue valor padro do atributo.
   */
  private ArrayAttribute(String name, boolean isOptional,
    String[] defaultValue) {
    super(name, String[].class, isOptional, defaultValue, null);
  }

  /**
   * Construtor para atributos obrigatrios.
   *
   * @param name nome do atributo.
   */
  public ArrayAttribute(String name) {
    this(name, false, null);
  }

  /**
   * Construtor para atributos opcionais.
   *
   * @param name nome do atributo.
   * @param defaultValue valor padro do atributo.
   */
  public ArrayAttribute(String name, String[] defaultValue) {
    this(name, true, defaultValue);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public StringToValueConverter<String[]> getValueConverter() {
    return this;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String[] valueOf(String value) throws ParseException {
    return value.trim().split("\\s*,\\s*");
  }
}
