package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.ChangeMaximumForDoublesTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeMaximumForIntegersTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.DoubleListParameterFactory;
import csbase.logic.algorithms.parsers.DoubleParameterFactory;
import csbase.logic.algorithms.parsers.IntegerListParameterFactory;
import csbase.logic.algorithms.parsers.IntegerParameterFactory;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * Fbrica de {@link ChangeMaximumForDoublesTrigger} ou
 * {@link ChangeMaximumForIntegersTrigger}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ChangeMaximumTriggerFactory extends
  AbstractSimpleTriggerFactory {
  /**
   * Atributo {@value #INCLUDE_NEW_MAXIMUM_ATTRIBUTE}: indica se o valor mximo
   * indicado por {@link #NEW_MAXIMUM_ATTRIBUTE} se  inclusivo ({@code true})
   * ou  exclusivo ({@code false}).  opcional (o valor-padro 
   * {@link #INCLUDE_NEW_MAXIMUM_DEFAULT_VALUE}).  do tipo booleano. S 
   * aplicvel se o parmetro for tipo do tipo real.
   */
  private static final String INCLUDE_NEW_MAXIMUM_ATTRIBUTE =
    "incluir_novo_maximo";

  /**
   * <p>
   * O valor-padro para o atributo {@link #INCLUDE_NEW_MAXIMUM_ATTRIBUTE}.
   * </p>
   * <p>
   * O seu valor  {@value #INCLUDE_NEW_MAXIMUM_DEFAULT_VALUE}.
   * </p>
   */
  private static final boolean INCLUDE_NEW_MAXIMUM_DEFAULT_VALUE = true;

  /**
   * Atributo {@value #NEW_MAXIMUM_ATTRIBUTE}: indica o valor mximo. 
   * obrigatrio. O seu tipo depende do tipo do parmetro.
   */
  private static final String NEW_MAXIMUM_ATTRIBUTE = "novo_maximo";

  /**
   * Cria a fbrica.
   */
  public ChangeMaximumTriggerFactory() {
    super("trocar_maximo", false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Trigger<?> doCreateTrigger(XmlParser parser, Condition condition,
    Parameter<?> parameter, SimpleAlgorithmConfigurator configurator)
      throws ParseException {
    Trigger<?> trigger;
    if (parameter instanceof DoubleParameter) {
      Double maximum = parser.extractAttributeValueAsDouble(
        NEW_MAXIMUM_ATTRIBUTE, null);
      boolean isMaximumIncluded = parser.extractAttributeValueAsBoolean(
        INCLUDE_NEW_MAXIMUM_ATTRIBUTE, INCLUDE_NEW_MAXIMUM_DEFAULT_VALUE);
      DoubleParameter doubleParameter = (DoubleParameter) parameter;
      trigger = new ChangeMaximumForDoublesTrigger(doubleParameter, condition,
        maximum, isMaximumIncluded);
    }
    else if (parameter instanceof DoubleListParameter) {
      Double maximum = parser.extractAttributeValueAsDouble(
        NEW_MAXIMUM_ATTRIBUTE, null);
      boolean isMaximumIncluded = parser.extractAttributeValueAsBoolean(
        INCLUDE_NEW_MAXIMUM_ATTRIBUTE, true);
      DoubleListParameter doubleListParameter = (DoubleListParameter) parameter;
      trigger = new ChangeMaximumForDoublesTrigger(doubleListParameter,
        condition, maximum, isMaximumIncluded);
    }
    else if (parameter instanceof IntegerParameter) {
      Integer maximum = parser.extractAttributeValueAsInteger(
        NEW_MAXIMUM_ATTRIBUTE, null);
      IntegerParameter integerParameter = (IntegerParameter) parameter;
      trigger = new ChangeMaximumForIntegersTrigger(integerParameter, condition,
        maximum);
    }
    else if (parameter instanceof IntegerListParameter) {
      Integer maximum = parser.extractAttributeValueAsInteger(
        NEW_MAXIMUM_ATTRIBUTE, null);
      IntegerListParameter integerListParameter =
        (IntegerListParameter) parameter;
      trigger = new ChangeMaximumForIntegersTrigger(integerListParameter,
        condition, maximum);
    }
    else {
      throw new ParseException("O parmetro {0} no  de um tipo vlido.\n"
        + "Tipos permitidos:\n{1};\n{2};\n{3};\n{4}.", parameter.getName(),
        DoubleParameterFactory.DOUBLE_PARAMETER_ELEMENT,
        DoubleListParameterFactory.DOUBLE_LIST_PARAMETER_ELEMENT,
        IntegerParameterFactory.INTEGER_PARAMETER_ELEMENT,
        IntegerListParameterFactory.INTEGER_LIST_PARAMETER_ELEMENT);
    }
    return trigger;
  }

}
