/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BasicColumn;
import csbase.logic.algorithms.parameters.validators.IntegerParameterValidator;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;

public final class IntegerColumn
extends BasicColumn<Integer> {
    private Integer maximum;
    private Integer minimum;

    public IntegerColumn(String id, String label, Integer defaultValue, boolean isOptional, boolean isEditable, Integer maximum, Integer minimum) {
        super(id, label, defaultValue, isOptional, isEditable);
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    @Override
    public Integer getItemValueFromText(String itemValue) throws ParseException {
        if (itemValue == null) {
            return null;
        }
        try {
            int intValue = Integer.parseInt(itemValue);
            return new Integer(intValue);
        }
        catch (NumberFormatException e) {
            throw new ParseException(e, "O valor {0} foi atribuido \u00e0 coluna {1}, por\u00e9m ele n\u00e3o \u00e9 um valor v\u00e1lido para um n\u00famero inteiro.", itemValue, this);
        }
    }

    public Integer getMaximum() {
        return this.maximum;
    }

    public Integer getMinimum() {
        return this.minimum;
    }

    private void setMaximum(Integer maximum) {
        if (this.minimum != null && maximum != null && maximum.compareTo(this.minimum) < 0) {
            throw new IllegalArgumentException("O valor m\u00e1ximo n\u00e3o pode ser menor do que o valor m\u00ednimo.");
        }
        this.maximum = maximum;
    }

    @Override
    public SimpleParameterValidator<Integer> getValidator() {
        return new IntegerParameterValidator(this.isOptional(), this.getMaximum(), this.getMinimum());
    }

    private void setMinimum(Integer minimum) {
        if (this.maximum != null && minimum != null && minimum.compareTo(this.maximum) > 0) {
            throw new IllegalArgumentException("O valor m\u00ednimo n\u00e3o pode ser maior do que o valor m\u00e1ximo.");
        }
        this.minimum = minimum;
    }
}

