package csbase.logic.algorithms.parsers.elements.attributes;

import csbase.exception.ParseException;

/**
 * Atributo do tipo string.
 */
public class StringAttribute extends AbstractElementAttribute<String>
  implements StringToValueConverter<String> {

  /**
   * Construtor.
   *
   * @param name nome do atributo.
   * @param isOptional indicativo de opcionalidade.
   * @param defaultValue valor padro do atributo.
   * @param defaultValueAttribute atributo com valor padro.
   */
  StringAttribute(String name, boolean isOptional, String defaultValue,
    StringAttribute defaultValueAttribute) {
    super(name, String.class, isOptional, defaultValue, defaultValueAttribute);
  }

  /**
   * Construtor para atributos opcionais.
   *
   * @param name nome do atributo.
   * @param defaultValue valor padro do atributo.
   */
  public StringAttribute(String name, String defaultValue) {
    this(name, true, defaultValue, null);
  }

  /**
   * Construtor para atributos obrigatrios.
   *
   * @param name nome do atributo.
   */
  public StringAttribute(String name) {
    this(name, false, null, null);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public StringToValueConverter<String> getValueConverter() {
    return this;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String valueOf(String string) throws ParseException {
    return string;
  }

}
