package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.HideParameterTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * Fbrica de {@link HideParameterTrigger}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class HideParameterTriggerFactory extends
  AbstractSimpleTriggerFactory {
  /**
   * Cria a fbrica.
   */
  public HideParameterTriggerFactory() {
    super("ocultar", true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Trigger<?> doCreateTrigger(XmlParser parser, Condition condition,
    Parameter<?> parameter, SimpleAlgorithmConfigurator configurator)
      throws ParseException {
    SimpleParameter<?> simpleParameter = (SimpleParameter<?>) parameter;
    return new HideParameterTrigger(simpleParameter, condition);
  }
}
