/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.DoubleStructureAttributes;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.attributes.DoubleAttribute;

public class DoubleParameterFactory
extends SimpleParameterParser<DoubleParameter>
implements DoubleStructureAttributes {
    public static final String DOUBLE_PARAMETER_ELEMENT = "real";

    @Override
    public DoubleParameter createSimpleParameter(XmlParser parser, ParsedSimpleParameter definition, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Double maximum = (Double)definition.getAttributeValue("maximo");
        boolean isMaximumIncluded = (Boolean)definition.getAttributeValue("incluir_maximo");
        Double minimum = (Double)definition.getAttributeValue("minimo");
        boolean isMinimumIncluded = (Boolean)definition.getAttributeValue("incluir_minimo");
        DoubleAttribute attribute = (DoubleAttribute)definition.getAttribute("padrao");
        attribute.setMinimumValue(minimum);
        attribute.setMaximumValue(maximum);
        Double defaultValue = (Double)definition.getAttributeValue("padrao");
        definition.checkValues();
        return new DoubleParameter(definition.getName(), definition.getLabel(), definition.getDescription(), defaultValue, definition.isOptional(), definition.isVisible(), definition.getCommandLinePattern(), maximum, isMaximumIncluded, minimum, isMinimumIncluded);
    }

    @Override
    public ParameterStructure<DoubleParameter> getParameterStructure() {
        ParameterStructure<DoubleParameter> doubleStructure = this.getDoubleStructure(DOUBLE_PARAMETER_ELEMENT, DoubleParameter.class);
        doubleStructure.addAttribute(new DoubleAttribute("padrao", null));
        return doubleStructure;
    }
}

