/*
 * Decompiled with CFR 0.152.
 */
package csbase.remote;

import csbase.logic.ObserverData;
import csbase.remote.RemoteEvent;
import csbase.remote.RemoteObserver;
import csbase.remote.RemoteObserverNotifierInterface;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RemoteObserversNotificationManager {
    private final Set<ObserverData> observersSet = new HashSet<ObserverData>();
    private final RemoteObserverNotifierInterface notifier;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();
    private final DateFormat format;

    public RemoteObserversNotificationManager(RemoteObserverNotifierInterface notifier, Locale locale) {
        this.notifier = notifier;
        this.format = DateFormat.getDateTimeInstance(2, 2, locale);
    }

    public boolean addObserver(ObserverData observer) {
        boolean inserted;
        this.writeLock.lock();
        try {
            inserted = this.observersSet.add(observer);
        }
        finally {
            this.writeLock.unlock();
        }
        if (inserted) {
            if (this.notifier.isLoggingNotifications()) {
                StringBuffer msg = new StringBuffer();
                msg.append(this);
                msg.append(": adicionado observador: ");
                msg.append(observer.observer);
                msg.append(" - ");
                msg.append(observer.arg);
                this.notifier.logNotification(msg.toString());
            }
        } else if (this.notifier.isLoggingNotifications()) {
            StringBuffer msg = new StringBuffer();
            msg.append(this);
            msg.append(": observador j\u00e1 existia: ");
            msg.append(observer.observer);
            msg.append(" - ");
            msg.append(observer.arg);
            this.notifier.logNotification(msg.toString());
        }
        return inserted;
    }

    public boolean deleteObserver(ObserverData observer) {
        boolean removed;
        this.writeLock.lock();
        try {
            removed = this.observersSet.remove(observer);
        }
        finally {
            this.writeLock.unlock();
        }
        if (removed) {
            if (this.notifier.isLoggingNotifications()) {
                StringBuffer msg = new StringBuffer();
                msg.append(this);
                msg.append(": removido observador: ");
                msg.append(observer.observer);
                msg.append(" - ");
                msg.append(observer.arg);
                this.notifier.logNotification(msg.toString());
            }
        } else if (this.notifier.isLoggingNotifications()) {
            StringBuffer msg = new StringBuffer();
            msg.append(this);
            msg.append(": observador n\u00e3o existia: ");
            msg.append(observer.observer);
            msg.append(" - ");
            msg.append(observer.arg);
            this.notifier.logNotification(msg.toString());
        }
        return removed;
    }

    public void deleteObservers() {
        this.writeLock.lock();
        try {
            this.observersSet.clear();
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.notifier.isLoggingNotifications()) {
            StringBuffer msg = new StringBuffer();
            msg.append(this);
            msg.append(": todos os observadores foram removidos");
            this.notifier.logNotification(msg.toString());
        }
    }

    public int numObservers() {
        this.readLock.lock();
        try {
            int n = this.observersSet.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.numObservers() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(RemoteEvent event) {
        this.readLock.lock();
        ArrayList<ObserverData> failedObservers = new ArrayList<ObserverData>();
        try {
            for (ObserverData obsData : this.observersSet) {
                try {
                    StringBuffer msg;
                    if (!this.notifier.has2update(obsData, event)) continue;
                    if (this.notifier.isLoggingNotifications()) {
                        msg = new StringBuffer();
                        msg.append(this);
                        msg.append(": notificando: ");
                        msg.append(obsData.observer.toString());
                        msg.append(" - ");
                        msg.append(event.toString());
                        msg.append(" de ");
                        msg.append(this.format.format(event.getCreationDate()));
                        this.notifier.logNotification(msg.toString());
                    }
                    obsData.observer.update(event);
                    if (!this.notifier.isLoggingNotifications()) continue;
                    msg = new StringBuffer();
                    msg.append(this);
                    msg.append(": notifica\u00e7\u00e3o a ");
                    msg.append(obsData.observer.toString());
                    msg.append(" enviada com sucesso");
                    this.notifier.logNotification(msg.toString());
                }
                catch (ConnectException e) {
                    this.notifier.handleFatalError(obsData, event, e);
                    failedObservers.add(obsData);
                }
                catch (NoSuchObjectException e) {
                    this.notifier.handleFatalError(obsData, event, e);
                    failedObservers.add(obsData);
                }
                catch (Exception e) {
                    this.notifier.handleException(obsData, event, e);
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        for (ObserverData observerData : failedObservers) {
            this.deleteObserver(observerData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(RemoteObserverNotifierInterface notifier, RemoteEvent[] events) {
        this.readLock.lock();
        ArrayList<ObserverData> failedObservers = new ArrayList<ObserverData>();
        try {
            for (ObserverData obsData : this.observersSet) {
                try {
                    StringBuffer msg;
                    if (!notifier.has2update(obsData, events)) continue;
                    if (notifier.isLoggingNotifications()) {
                        msg = new StringBuffer();
                        msg.append(this);
                        msg.append(": notificando: ");
                        msg.append(obsData.observer.toString());
                        msg.append(" - ");
                        for (int i = 0; i < events.length; ++i) {
                            if (i > 0) {
                                msg.append(" - ");
                            }
                            msg.append(events[i].toString());
                            msg.append(" de ");
                            msg.append(this.format.format(events[i].getCreationDate()));
                        }
                        notifier.logNotification(msg.toString());
                    }
                    obsData.observer.update(events);
                    if (!notifier.isLoggingNotifications()) continue;
                    msg = new StringBuffer();
                    msg.append(this);
                    msg.append(": notifica\u00e7\u00f5es a ");
                    msg.append(obsData.observer.toString());
                    msg.append(" enviadas com sucesso");
                    notifier.logNotification(msg.toString());
                }
                catch (ConnectException e) {
                    notifier.handleFatalError(obsData, events, e);
                    failedObservers.add(obsData);
                }
                catch (NoSuchObjectException e) {
                    notifier.handleFatalError(obsData, events, e);
                    failedObservers.add(obsData);
                }
                catch (Exception e) {
                    notifier.handleException(obsData, events, e);
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        for (ObserverData observerData : failedObservers) {
            this.deleteObserver(observerData);
        }
    }

    public boolean addObserver(RemoteObserver observer) {
        return this.addObserver(new ObserverData(observer, null));
    }

    public boolean deleteObserver(RemoteObserver observer) {
        return this.deleteObserver(new ObserverData(observer, null));
    }
}

