/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.ProjectFileType;
import csbase.logic.algorithms.parameters.FileListParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileURLValue;
import java.util.List;
import tecgraf.javautils.core.io.FileUtils;

public class OutputFileListParameter
extends FileListParameter {
    public static final String TYPE = "OUTPUT_FILE";
    private boolean mustForceExtension;

    public OutputFileListParameter(String name, String label, String description, List<FileURLValue> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String[] fileTypes, FileParameterMode mode, boolean mustSort, boolean usesFilter, boolean mustForceExtension) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, fileTypes, mode, mustSort, usesFilter, false);
        if (fileTypes != null && fileTypes.length > 1) {
            String errorMessage = "Par\u00e2metro n\u00e3o aceita m\u00faltiplos tipos de arquivo associados.";
            throw new IllegalArgumentException(errorMessage);
        }
        this.mustForceExtension = mustForceExtension;
    }

    @Override
    public boolean mustWarnOverwrite() {
        return true;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean mustForceExtension() {
        return this.mustForceExtension;
    }

    @Override
    public boolean setValue(List<FileURLValue> files) {
        this.checkExtension(files);
        return super.setValue(files);
    }

    private void checkExtension(List<FileURLValue> files) {
        if (files != null && this.mustForceExtension()) {
            for (FileURLValue file : files) {
                String filePath = file.getPath();
                String fileExtension = FileUtils.getFileExtension((String)filePath);
                String[] types = this.getFileTypes();
                if (types == null || types.length != 1) {
                    return;
                }
                String type = types[0];
                ProjectFileType projectFileType = ProjectFileType.getFileType(type);
                if (projectFileType == null) {
                    return;
                }
                List<String> extensions = projectFileType.getExtensions();
                if (extensions.isEmpty()) {
                    return;
                }
                if (fileExtension != null && extensions.contains(fileExtension)) continue;
                filePath = filePath + '.' + extensions.get(0);
                file.setPath(filePath);
            }
        }
    }
}

