/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.elements.attributes;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.elements.ParsedElement;
import csbase.logic.algorithms.parsers.elements.attributes.IElementAttribute;

public abstract class AbstractElementAttribute<T>
implements IElementAttribute<T> {
    private final String name;
    private final Class<T> type;
    private final boolean optional;
    private IElementAttribute<T> defaultValueAttribute;
    private T defaultValue;

    protected AbstractElementAttribute(String name, Class<T> type, boolean optional, T defaultValue, IElementAttribute<T> defaultValueAttribute) {
        this.name = name;
        this.type = type;
        this.optional = optional;
        this.defaultValue = defaultValue;
        this.defaultValueAttribute = defaultValueAttribute;
    }

    public void setDefaultValueAttribute(IElementAttribute<T> defaultValueAttribute) {
        this.defaultValueAttribute = defaultValueAttribute;
    }

    @Override
    public IElementAttribute<T> getDefaultValueAttribute() {
        return this.defaultValueAttribute;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean validate(ParsedElement definition) throws ParseException {
        Object attributeValue = definition.getAttributeValue(this.name);
        if (attributeValue == null && !this.isOptional() && this.getDefaultValue() != null) {
            IElementAttribute<T> defaultValueParameter = this.getDefaultValueAttribute();
            if (defaultValueParameter != null) {
                Object value = definition.getAttributeValue(defaultValueParameter.getName());
                if (value != null) {
                    throw new ParseException("O atributo obrigat\u00f3rio {1} n\u00e3o foi encontrado.", this.name);
                }
            } else {
                throw new ParseException("O atributo obrigat\u00f3rio {1} n\u00e3o foi encontrado.", this.name);
            }
        }
        return true;
    }
}

