/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import java.text.MessageFormat;

public final class ChangeMinimumForIntegersTrigger
extends Trigger<SimpleParameter<?>> {
    private Integer minimum;

    public ChangeMinimumForIntegersTrigger(IntegerParameter parameter, Condition condition, Integer minimum) {
        super(parameter, condition);
        this.minimum = minimum;
    }

    public ChangeMinimumForIntegersTrigger(IntegerListParameter parameter, Condition condition, Integer minimum) {
        super(parameter, condition);
        this.minimum = minimum;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChangeMinimumForIntegersTrigger trigger = (ChangeMinimumForIntegersTrigger)obj;
        if (this.minimum == null && trigger.minimum == null) {
            return true;
        }
        return this.minimum != null && this.minimum.equals(trigger.minimum);
    }

    public Integer getMinimum() {
        return this.minimum;
    }

    @Override
    protected void doAction() {
        SimpleParameter parameter = (SimpleParameter)this.getParameter();
        if (parameter instanceof IntegerListParameter) {
            IntegerListParameter intListParameter = (IntegerListParameter)parameter;
            intListParameter.setMinimum(this.getMinimum());
        } else if (parameter instanceof IntegerParameter) {
            IntegerParameter intParameter = (IntegerParameter)parameter;
            intParameter.setMinimum(this.getMinimum());
        } else {
            throw new IllegalStateException(MessageFormat.format("O par\u00e2metro {0} n\u00e3o \u00e9 de um tipo v\u00e1lido.\nTipos permitidos:\n{1};\n{2}.", parameter.getLabel(), "real", "lista_de_reais"));
        }
    }

    @Override
    protected void undoAction() {
    }
}

