package csbase.logic;

import java.io.Serializable;

/**
 * Conjunto de informaes sobre a finalizao do comando.
 */
public interface CommandFinalizationInfo extends Serializable {

  /**
   * Tipo de informao de finalizao disponvel para o comando.
   */
  public enum FinalizationInfoType {
    /**
     * Informaes simples.
     */
    SIMPLE,
    /**
     * Informaes compostas (utilizada para o caso de fluxos).
     */
    EXTENDED;
  }

  /**
   * Retorna o tipo de informao de finalizao disponvel para o comando, pode
   * ser {@link CommandFinalizationInfo.FinalizationInfoType#SIMPLE} ou
   * {@link CommandFinalizationInfo.FinalizationInfoType#EXTENDED}.
   * 
   * @return commandType O tipo de informao de finalizao.
   */
  public FinalizationInfoType getInfoType();

  /**
   * Retorna o cdigo de sada do comando.
   * 
   * @return o cdigo de sada.
   */
  public Integer getExitCode();

  /**
   * Retorna o tipo de finalizao do comando.
   * 
   * @return o tipo de finalizao.
   */
  public CommandFinalizationType getFinalizationType();

  /**
   * Retorna o tipo <code>FailureFinalizationType</code> com a causa da falha do
   * comando ou null caso o comando no tenha falhado na execuo. Somente
   * existe se o {@link #getFinalizationType()} retornar
   * {@link CommandFinalizationType#FAILED}.
   * 
   * @return a causa da falha do comando ou null.
   */
  public FailureFinalizationType getFailureCause();

  /**
   * Indica se o comando gerou alertas durante sua execuo.
   *
   * @return verdadeiro caso o comando tenha gerado alertas ou falso, caso
   * contrrio.
   */
  public boolean hasWarnings();

}
