package csbase.logic.algorithms.parsers.columns;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BooleanColumn;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parsers.BooleanParameterFactory;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * Fbrica para {@link BooleanColumn}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class BooleanColumnFactory extends AbstractTableColumnFactory {

  /**
   * <p>
   * O elemento {@value #ELEMENT_NAME}: descreve uma {@link BooleanColumn coluna
   * do tipo booleano} de um {@link TableParameter parmetro do tipo tabela}.
   * </p>
   */
  private static final String ELEMENT_NAME = "coluna_de_booleanos";

  /**
   * Cria a fbrica.
   */
  public BooleanColumnFactory() {
    super(ELEMENT_NAME);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setCellValue(XmlParser parser, String parameterName,
    TableColumn<?> column, int rowIndex, String valueAttributeName)
      throws ParseException {
    BooleanColumn booleanColumn = (BooleanColumn) column;
    boolean cellValue = parser.extractAttributeValueAsBoolean(
      valueAttributeName);
    booleanColumn.addDefaultValue(rowIndex, cellValue);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected BooleanColumn createColumn(XmlParser parser, String parameterName,
    String label, String id, boolean isOptional, boolean isEditable,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    String falseCommand = parser.extractAttributeValue(
      BooleanParameterFactory.BOOLEAN_ELEMENT_FALSE_ATTRIBUTE, null);
    String trueCommand = parser.extractAttributeValue(
      BooleanParameterFactory.BOOLEAN_ELEMENT_TRUE_ATTRIBUTE, null);
    boolean defaultValue = parser.extractAttributeValueAsBoolean(
      COLUMN_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, false);
    parser.checkAttributes();
    parser.checkChildElements();
    return new BooleanColumn(id, label, defaultValue, isEditable, falseCommand,
      trueCommand);
  }
}
