/*
 * $Id$
 */
package csbase.remote;

import java.rmi.RemoteException;
import java.util.Date;

import csbase.logic.eventlogservice.LogsInfo;

/**
 * Interface remota para acesso ao servio de log cliente.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface EventLogServiceInterface extends ServiceInterface {

  /**
   * Nome do servio para o {@code ServiceManager}
   */
  public static final String SERVICE_NAME = "EventLogService";

  /**
   * Adiciona uma informao na fila especificada; caso a fila ainda no exista,
   * ela  criada. A informao  escrita, linha a linha, no formato CSV, na
   * forma:
   * 
   * <pre>
   * [data numrica]; [data textual]; [usurio]; [informaes recebidas]
   * </pre>
   * 
   * A <i>data numrica</i>  o nmero de milisegundos desde o "epoch" como um
   * long int. Todas as informaes passadas ao mtodo so colocadas, no formato
   * CSV separadas por ponto e vrgulas, aps a chave do usurio.
   * 
   * @param queue fila de armazenamento.
   * @param info informaes a serem gravadas.
   * @throws RemoteException no caso de falha.
   * @return true se a informao foi logada com sucesso
   */
  public boolean addClientInformation(final String[] queue, final String[] info)
    throws RemoteException;

  /**
   * Pesquisa nas filas e no perodo de tempo indicados quais informaes
   * encontram-se nos logs de eventos.
   * 
   * @param queues filas de armazenamento desejadas
   * @param initialDate data inicial da busca
   * @param finalDate data final da busca
   * 
   * @return resultado da busca
   *
   * @throws RemoteException em caso de erro de comunicao.
   */
  public LogsInfo find(final String[][] queues, final Date initialDate,
    final Date finalDate) throws RemoteException;

}
