/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ClientProjectFile;
import csbase.logic.NewProjectFileEvent;
import csbase.logic.NewProjectFilesEvent;
import csbase.logic.ProjectEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

class NewFileObserver
implements Observer {
    private ClientProjectFile[] newFiles;
    private final ClientProjectFile parentDir;
    private final Collection<String> names;

    public NewFileObserver(ClientProjectFile parentDir, String[] names) {
        this.parentDir = parentDir;
        this.names = Arrays.asList(names);
    }

    @Override
    public void update(Observable observable, Object arg) {
        ProjectEvent action = (ProjectEvent)arg;
        if (action == null) {
            return;
        }
        switch (action.event) {
            case 3: {
                NewProjectFileEvent event = (NewProjectFileEvent)action;
                ClientProjectFile file = event.getFile();
                if (file == null) {
                    return;
                }
                String[] path = event.getPath();
                if (path == null) {
                    return;
                }
                if (!NewFileObserver.pathEquals(path, this.parentDir.getPath()) || !this.names.contains(file.getName())) {
                    return;
                }
                this.setNewFiles(new ClientProjectFile[]{file});
                break;
            }
            case 11: {
                NewProjectFilesEvent event = (NewProjectFilesEvent)action;
                ClientProjectFile[] files = event.getFiles();
                if (files == null || files.length == 0) {
                    return;
                }
                String[][] paths = event.getPaths();
                if (paths.length != files.length) {
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    if (this.checkPath(paths[i], this.parentDir.getPath()) && this.names.contains(files[i].getName())) continue;
                    return;
                }
                this.setNewFiles(files);
                break;
            }
            default: {
                return;
            }
        }
    }

    private boolean checkPath(String[] pathToCheck, String[] referencePath) {
        if (pathToCheck.length < referencePath.length) {
            return false;
        }
        for (int i = 0; i < referencePath.length; ++i) {
            if (pathToCheck[i].equals(referencePath[i])) continue;
            return false;
        }
        return true;
    }

    private synchronized void setNewFiles(ClientProjectFile[] files) {
        this.newFiles = files;
        this.notify();
    }

    public synchronized ClientProjectFile[] getNewFiles() {
        while (this.newFiles == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.newFiles;
    }

    private static final boolean pathEquals(String[] path1, String[] path2) {
        if (null == path1 && null == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.length != path2.length) {
            return false;
        }
        for (int inx = 0; inx < path1.length; ++inx) {
            if (path1[inx].equals(path2[inx])) continue;
            return false;
        }
        return true;
    }
}

