/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.URLListParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

public final class InputURLListParameter
extends URLListParameter {
    public static final String TYPE_VALUE = "INPUT_URL";

    public InputURLListParameter(String name, String label, String description, List<FileURLValue> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String localization, String[] fileTypes, FileParameterMode mode, boolean mustSort, EnumSet<URLProtocol> allowedProtocols) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, localization, fileTypes, mode, mustSort, true, allowedProtocols);
    }

    @Override
    public String getType() {
        return TYPE_VALUE;
    }

    @Override
    public String getValueAsJSON() {
        if (this.getValue() == null) {
            return null;
        }
        ArrayList<String> files = new ArrayList<String>();
        for (FileURLValue file : (List)this.getValue()) {
            files.add(file.getPath());
        }
        return this.objectToJSON(files);
    }

    @Override
    public void setJSONValue(Object value) {
        Collection list = (Collection)List.class.cast(value);
        list.forEach(i -> this.addElement(new FileURLValue((String)i)));
    }
}

