/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;

public final class SetVisibleEnumerationItemTrigger
extends Trigger<EnumerationParameter> {
    private String itemId;
    private boolean isVisible;

    public SetVisibleEnumerationItemTrigger(EnumerationParameter parameter, Condition condition, String itemId, boolean isVisible) {
        super(parameter, condition);
        this.setItemId(itemId);
        this.isVisible = isVisible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SetVisibleEnumerationItemTrigger trigger = (SetVisibleEnumerationItemTrigger)obj;
        if (!this.getItemId().equals(trigger.getItemId())) {
            return false;
        }
        return this.isVisible() == trigger.isVisible();
    }

    public String getItemId() {
        return this.itemId;
    }

    @Override
    protected void doAction() {
        ((EnumerationParameter)this.getParameter()).setVisibleItem(this.itemId, this.isVisible);
    }

    @Override
    protected void undoAction() {
        ((EnumerationParameter)this.getParameter()).setVisibleItem(this.itemId, !this.isVisible);
    }

    private void setItemId(String itemId) {
        if (itemId == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "itemId"));
        }
        this.itemId = itemId;
    }
}

