/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.OperationFailureException;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.triggers.AbstracTriggerFactory;
import java.util.Collection;

public abstract class AbstractGroupTriggerFactory
extends AbstracTriggerFactory {
    private static final String GROUP_ATTRIBUTE = "grupo";
    private static final String GROUP_ELEMENT = "grupo";
    private static final String GROUP_ELEMENT_ID_ATTRIBUTE = "id";

    protected AbstractGroupTriggerFactory(String elementName, boolean allowMultiples) {
        super(elementName, "grupo", GROUP_ELEMENT_ID_ATTRIBUTE, "grupo", allowMultiples);
    }

    protected final ParameterGroup findParameter(SimpleAlgorithmConfigurator configurator, String parameterName) throws OperationFailureException {
        ParameterGroup triggerGroup = this.findGroupByName(configurator.getGroups(), parameterName);
        return triggerGroup;
    }

    private ParameterGroup findGroupByName(Collection<ParameterGroup> groups, String groupName) throws OperationFailureException {
        ParameterGroup groupFound = null;
        for (ParameterGroup group : groups) {
            ParameterGroup childGroup;
            if (group.getName().equals(groupName)) {
                if (groupFound == null) {
                    groupFound = group;
                } else {
                    throw new OperationFailureException("Foi encontrado mais de um grupo com o identificador \"{0}\".", groupName);
                }
            }
            if ((childGroup = this.findGroupByName(group.getGroups(), groupName)) == null) continue;
            if (groupFound == null) {
                groupFound = childGroup;
                continue;
            }
            throw new OperationFailureException("Foi encontrado mais de um grupo com o identificador \"{0}\".", groupName);
        }
        return groupFound;
    }
}

