/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.Priority;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.serializer.AlgorithmConfigurationSerializerFactory;
import csbase.logic.algorithms.serializer.IAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CommandSubmission
implements Serializable {
    private String configuratorToString;
    private String configuratorSerializerClassName;
    private byte[] configuratorData;
    private String description;
    private Integer executionCountForMultipleExecution;
    private Integer executionCountPerSGAForMultipleExecution;
    private ExecutionType executionType;
    private boolean mailAtEnd;
    private String[] emailList;
    private String platform;
    private Priority priority;
    private Object projectId;
    private List<String> sgaNames;
    private Date submittedDate;
    private Map<String, String> extraInfoMap;
    private String clientHostName;

    public CommandSubmission(AlgorithmConfigurator configurator, Object projectId, String clientHostName) {
        this.clientHostName = clientHostName;
        this.setAlgorithmConfigurator(configurator);
        this.projectId = projectId;
        this.sgaNames = new LinkedList<String>();
        this.priority = Priority.getDefault();
        this.submittedDate = new Date();
        this.extraInfoMap = new HashMap<String, String>();
        this.configureSimpleExecution();
    }

    public CommandSubmission(AlgorithmConfigurator configurator, Object projectId) {
        this(configurator, projectId, null);
    }

    public void configureMultipleExecution(int executionCount) {
        this.executionType = ExecutionType.MULTIPLE;
        this.executionCountForMultipleExecution = executionCount;
    }

    public void configureMultipleExecution(List<String> sgaNames, int executionCountPerSGA) {
        this.executionType = ExecutionType.MULTIPLE;
        this.setSGANames(sgaNames);
        this.executionCountPerSGAForMultipleExecution = executionCountPerSGA;
        this.executionCountForMultipleExecution = executionCountPerSGA * this.sgaNames.size();
    }

    public void configureSimpleExecution() {
        this.configureSimpleExecution(null);
    }

    public void configureSimpleExecution(String sgaName) {
        this.executionType = ExecutionType.SIMPLE;
        this.setSGAName(sgaName);
    }

    public AlgorithmConfigurator createAlgorithmConfigurator() throws AlgorithmConfigurationSerializerException, IOException {
        IAlgorithmConfigurationSerializer serializer = AlgorithmConfigurationSerializerFactory.getSerializer(this.configuratorSerializerClassName);
        try (ByteArrayInputStream serializerInput = new ByteArrayInputStream(this.configuratorData);){
            AlgorithmConfigurator algorithmConfigurator = serializer.read(serializerInput);
            return algorithmConfigurator;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getExecutionCountForMultipleExecution() {
        return this.executionCountForMultipleExecution;
    }

    public Integer getExecutionCountPerSGAForMultipleExecution() {
        return this.executionCountPerSGAForMultipleExecution;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Object getProjectId() {
        return this.projectId;
    }

    public List<String> getSGANames() {
        return this.sgaNames;
    }

    public Date getSubmittedDate() {
        return this.submittedDate;
    }

    public Map<String, String> getExtraInfoMap() {
        return this.extraInfoMap;
    }

    public boolean isAutomatic() {
        return this.sgaNames.isEmpty();
    }

    public boolean isMailAtEnd() {
        return this.mailAtEnd;
    }

    public boolean isManual() {
        return !this.isAutomatic();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMailAtEnd(boolean mailAtEnd) {
        this.mailAtEnd = mailAtEnd;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Submiss\u00e3o:\n");
        buffer.append("configurador: " + this.configuratorToString + "\n");
        buffer.append("descri\u00e7\u00e3o: " + this.description + "\n");
        buffer.append("prioridade: " + (Object)((Object)this.priority) + "\n");
        return buffer.toString();
    }

    private void setSGAName(String sgaName) {
        this.sgaNames.clear();
        if (sgaName != null) {
            this.sgaNames.add(sgaName);
        }
    }

    private void setSGANames(List<String> sgaNames) {
        this.sgaNames.clear();
        this.sgaNames.addAll(sgaNames);
    }

    private void setAlgorithmConfigurator(AlgorithmConfigurator configurator) {
        IAlgorithmConfigurationSerializer serializer = configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW && configurator.getAlgorithmVersion() == null ? AlgorithmConfigurationSerializerFactory.getSerializer(FlowAlgorithmConfigurator.class) : AlgorithmConfigurationSerializerFactory.getDefaultSerializer();
        this.configuratorSerializerClassName = serializer.getClass().getName();
        try (ByteArrayOutputStream serializerOutput = new ByteArrayOutputStream();){
            serializer.write(configurator, serializerOutput);
            this.configuratorData = serializerOutput.toByteArray();
            this.configuratorToString = configurator.toString();
        }
        catch (AlgorithmConfigurationSerializerException e) {
            this.configuratorSerializerClassName = null;
            this.configuratorData = null;
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            this.configuratorSerializerClassName = null;
            this.configuratorData = null;
            e.printStackTrace();
        }
    }

    public void addExtraInfo(String key, String value) {
        this.extraInfoMap.put(key, value);
    }

    public void setEmailList(String[] emailList) {
        this.emailList = emailList;
    }

    public String[] getEmailList() {
        return this.emailList;
    }

    public String getClientHostName() {
        return this.clientHostName;
    }
}

