/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parameters.HiddenParameter;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.ParameterLoader;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.EnumerationItemFactory;
import csbase.logic.algorithms.parsers.HiddenParameterParser;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.logic.algorithms.parsers.ParameterLoaderParser;
import csbase.logic.algorithms.parsers.ParameterParser;
import csbase.logic.algorithms.parsers.ValidationExpressionParser;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.triggers.TriggerParser;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public final class SimpleAlgorithmParser
extends ParameterParser {
    static final String ALGORITHM_ELEMENT = "algoritmo";
    static final String ALGORITHM_ELEMENT_ABBREVIATION_ATTRIBUTE = "abreviatura";
    static final String ALGORITHM_ELEMENT_COMMAND_ATTRIBUTE = "comando";
    static final String ALGORITHM_ELEMENT_DEFAULT_INPUT_FILE_ATTRIBUTE = "arquivo_de_entrada_padrao";
    static final String ALGORITHM_ELEMENT_EXECUTION_TYPE_ATTRIBUTE = "tipo_de_execucao";
    static final String ALGORITHM_ELEMENT_EXECUTION_LOCATION_ATTRIBUTE = "local_de_execucao";
    static final String ALGORITHM_ELEMENT_EXECUTION_TYPE_VALUE_SIMPLE = "simples";
    static final String[] ALGORITHM_ELEMENT_EXECUTION_TYPE_VALUES_MULTIPLE = new String[]{"multipla", "m\u00faltipla"};
    static final String ALGORITHM_ELEMENT_PROVIDE_ID_ATTRIBUTE = "fornecer_identificador";
    static final boolean ALGORITHM_ELEMENT_PROVIDE_ID_DEFAULT_VALUE = false;
    static final String ALGORITHM_ELEMENT_SHOW_OUTPUT_ATTRIBUTE = "exibir_saida";
    static final boolean ALGORITHM_ELEMENT_SHOW_OUTPUT_DEFAULT_VALUE = false;
    static final String ALGORITHM_ELEMENT_SHELL_ATTRIBUTE = "shell";
    static final String ALGORITHM_ELEMENT_CAPTURE_EXIT_CODE_ATTRIBUTE = "capturar_codigo_de_saida";
    static final boolean ALGORITHM_ELEMENT_CAPTURE_EXIT_CODE_DEFAULT_VALUE = false;
    static final String DESCRIPTION_ELEMENT = "descricao";
    static final String GROUP_ELEMENT = "grupo";
    static final String GROUP_ELEMENT_LABEL_ATTRIBUTE = "rotulo";
    static final String GROUP_ELEMENT_ID_ATTRIBUTE = "id";
    static final String GROUP_ELEMENT_COLLAPSIBLE_ATTRIBUTE = "minimizavel";
    static final boolean GROUP_ELEMENT_COLLAPSIBLE_ATTRIBUTE_DEFAULT_VALUE = false;
    static final String PARAMETER_ELEMENT = "parametro";
    private String currentCommandLinePattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleAlgorithmConfigurator load(Reader configXmlReader, Map<String, String> paramConfigProperties, Map<String, ParameterFactory> paramFactories, AlgorithmVersionInfo algorithmVersion, ExecutionLocation defaultExecutionLocation, String defaultCommandLinePattern) throws ParseException {
        if (configXmlReader == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "configXmlReader"));
        }
        if (algorithmVersion == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "algorithmVersion"));
        }
        if (paramConfigProperties == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "replacementMap"));
        }
        if (paramFactories == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "paramProperties"));
        }
        XmlParser parser = new XmlParser(paramConfigProperties);
        parser.parseDocument(configXmlReader);
        parser.goToRoot();
        parser.ensureElementName(ALGORITHM_ELEMENT);
        String command = parser.extractAttributeValue(ALGORITHM_ELEMENT_COMMAND_ATTRIBUTE);
        String shell = parser.extractAttributeValue(ALGORITHM_ELEMENT_SHELL_ATTRIBUTE, null);
        boolean captureExitCode = parser.extractAttributeValueAsBoolean(ALGORITHM_ELEMENT_CAPTURE_EXIT_CODE_ATTRIBUTE, false);
        String defaultInputFileParameterName = parser.extractAttributeValue(ALGORITHM_ELEMENT_DEFAULT_INPUT_FILE_ATTRIBUTE, null);
        boolean provideId = parser.extractAttributeValueAsBoolean(ALGORITHM_ELEMENT_PROVIDE_ID_ATTRIBUTE, false);
        boolean showOutput = parser.extractAttributeValueAsBoolean(ALGORITHM_ELEMENT_SHOW_OUTPUT_ATTRIBUTE, false);
        String description = this.loadDescription(parser);
        ExecutionType executionType = this.loadExecutionType(parser);
        ExecutionLocation executionLocation = parser.extractAttributeValueAsEnumeration(ALGORITHM_ELEMENT_EXECUTION_LOCATION_ATTRIBUTE, defaultExecutionLocation, new ExecutionLocation.ExecutionLocationConverter());
        String abbreviation = parser.extractAttributeValue(ALGORITHM_ELEMENT_ABBREVIATION_ATTRIBUTE, null);
        this.currentCommandLinePattern = this.loadCommandLinePattern(parser, defaultCommandLinePattern);
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(algorithmVersion, description, executionType, executionLocation, abbreviation, provideId, command, shell, defaultInputFileParameterName, showOutput, this.currentCommandLinePattern);
        try {
            configurator.setHasExitCode(captureExitCode);
            this.loadGroups(parser, configurator, paramFactories);
            this.loadExpressions(parser, configurator);
            this.loadTriggers(parser, configurator);
            this.loadHiddenParameters(parser, configurator);
            this.checkDefaultInputFileParameter(defaultInputFileParameterName, configurator);
            parser.checkAttributes();
            parser.goToRoot();
        }
        finally {
            this.currentCommandLinePattern = defaultCommandLinePattern;
        }
        return configurator;
    }

    private void loadTriggers(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        TriggerParser triggerParser = new TriggerParser();
        triggerParser.loadTriggers(parser, configurator);
    }

    public void loadModifications(SimpleAlgorithmConfigurator configurator, Reader configXmlReader) throws ParseException {
        XmlParser parser = new XmlParser(new HashMap<String, String>());
        parser.parseDocument(configXmlReader);
        parser.goToRoot();
        parser.ensureElementName(ALGORITHM_ELEMENT);
        parser.checkAttributes();
        boolean hasElements = parser.goToFirstChild();
        while (hasElements) {
            parser.ensureElementName(PARAMETER_ELEMENT);
            String name = parser.extractAttributeValue("nome");
            parser.checkAttributes();
            SimpleParameter<?> parameter = configurator.getSimpleParameter(name);
            if (parameter == null) {
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.ParameterNotFound"), name);
            }
            if (!(parameter instanceof EnumerationListParameter)) {
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.MultiSelectionParamOnly"), name, "enumeracao");
            }
            EnumerationListParameter enumParameter = (EnumerationListParameter)parameter;
            List<EnumerationItem> items = new EnumerationItemFactory().loadEnumerationItems(parser, name);
            enumParameter.setItems(items);
            hasElements = parser.goToNextSibling();
        }
        parser.goToRoot();
    }

    private void checkDefaultInputFileParameter(String defaultInputFileParameterName, SimpleAlgorithmConfigurator configurator) throws ParseException {
        if (defaultInputFileParameterName != null) {
            List<InputFileParameter> inputFileParameters = configurator.getInputFileParameters();
            for (InputFileParameter inputFileParameter : inputFileParameters) {
                if (!inputFileParameter.getName().equals(defaultInputFileParameterName)) continue;
                return;
            }
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.UndefinedUsedParam"), defaultInputFileParameterName, ALGORITHM_ELEMENT_DEFAULT_INPUT_FILE_ATTRIBUTE, ALGORITHM_ELEMENT, configurator.getAlgorithmVersion().getInfo(), configurator.getAlgorithmVersion().getId());
        }
    }

    private void checkParameterLoader(ParameterGroup group) throws ParseException {
        ParameterLoader parameterLoader = group.getParameterLoader();
        if (parameterLoader != null) {
            for (String inputParameterName : parameterLoader.getInputParameterNames()) {
                if (group.getSimpleParameter(inputParameterName) != null) continue;
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.NonExistentParameter"), inputParameterName, "parametro_de_entrada");
            }
        }
    }

    private String loadDescription(XmlParser parser) throws ParseException {
        if (!parser.goToFirstChild(DESCRIPTION_ELEMENT)) {
            return null;
        }
        String description = parser.getElementValue(null);
        parser.checkAttributes();
        parser.checkChildElements();
        parser.goToParent();
        return description;
    }

    private ExecutionType loadExecutionType(XmlParser parser) throws ParseException {
        String executionTypeName = parser.extractAttributeValue(ALGORITHM_ELEMENT_EXECUTION_TYPE_ATTRIBUTE, ALGORITHM_ELEMENT_EXECUTION_TYPE_VALUE_SIMPLE);
        if (executionTypeName.equals(ALGORITHM_ELEMENT_EXECUTION_TYPE_VALUE_SIMPLE)) {
            return ExecutionType.SIMPLE;
        }
        for (String value : ALGORITHM_ELEMENT_EXECUTION_TYPE_VALUES_MULTIPLE) {
            if (!executionTypeName.equals(value)) continue;
            return ExecutionType.MULTIPLE;
        }
        throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.InvalidExecutionType"), executionTypeName, ALGORITHM_ELEMENT_EXECUTION_TYPE_ATTRIBUTE, ALGORITHM_ELEMENT);
    }

    private void loadExpressions(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        if (parser.goToFirstChild("expressao")) {
            ValidationExpressionParser expressionParser = new ValidationExpressionParser();
            do {
                expressionParser.loadExpression(parser, configurator);
            } while (parser.goToNextSibling("expressao"));
            parser.goToParent();
        }
    }

    private ParameterGroup loadGroup(XmlParser parser, SimpleAlgorithmConfigurator configurator, Map<String, ParameterFactory> paramFactories) throws ParseException {
        String groupLabel = parser.extractAttributeValue(GROUP_ELEMENT_LABEL_ATTRIBUTE);
        String groupId = parser.extractAttributeValue(GROUP_ELEMENT_ID_ATTRIBUTE, groupLabel);
        boolean isCollapsible = parser.extractAttributeValueAsBoolean(GROUP_ELEMENT_COLLAPSIBLE_ATTRIBUTE, false);
        ParameterGroup group = new ParameterGroup(groupId, groupLabel, isCollapsible);
        if (parser.goToFirstChild()) {
            do {
                Parameter parameter = null;
                String elementName = parser.getElementName();
                if (elementName.equals(GROUP_ELEMENT)) {
                    parameter = this.loadGroup(parser, configurator, paramFactories);
                } else if (elementName.equals("carregar_parametros")) {
                    ParameterLoaderParser parameterLoaderParser = new ParameterLoaderParser();
                    parameterLoaderParser.loadParameterLoader(parser, group);
                } else {
                    parameter = this.loadSimpleParameter(parser, paramFactories, group, configurator);
                }
                if (parameter == null || group.addParameter(parameter)) continue;
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.ParamExistsInGroup"), parameter, group);
            } while (parser.goToNextSibling());
            parser.goToParent();
        }
        parser.checkAttributes();
        this.checkParameterLoader(group);
        return group;
    }

    private Parameter<?> loadSimpleParameter(XmlParser parser, Map<String, ParameterFactory> paramFactories, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String elementName = parser.getElementName();
        if (paramFactories.containsKey(elementName)) {
            ParameterFactory factory = paramFactories.get(elementName);
            try {
                return factory.createParameter(parser, this.currentCommandLinePattern, group, configurator);
            }
            catch (ParseException e) {
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.UnableToCreateElement"), elementName, factory.getClass().getName(), e.getMessage());
            }
        }
        throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.ElementNotInConfigurator"), elementName);
    }

    private void loadGroups(XmlParser parser, SimpleAlgorithmConfigurator configurator, Map<String, ParameterFactory> paramFactories) throws ParseException {
        if (parser.goToFirstChild(GROUP_ELEMENT)) {
            do {
                ParameterGroup group;
                if (configurator.addGroup(group = this.loadGroup(parser, configurator, paramFactories))) continue;
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.ExistentGroupInAlgo"), group, configurator);
            } while (parser.goToNextSibling(GROUP_ELEMENT));
            parser.goToParent();
        }
    }

    private void loadHiddenParameters(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        if (parser.goToFirstChild("oculto")) {
            HiddenParameterParser hiddenParameterParser = new HiddenParameterParser();
            do {
                HiddenParameter hiddenParameter;
                if (configurator.addHiddenParameter(hiddenParameter = hiddenParameterParser.createParameter(parser, this.currentCommandLinePattern, null, configurator))) continue;
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.ExistentGroupInAlgo"), hiddenParameter, configurator);
            } while (parser.goToNextSibling("oculto"));
            parser.goToParent();
        }
    }
}

