/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.ParameterLoader;
import csbase.logic.algorithms.parsers.XmlParser;
import tecgraf.javautils.core.lng.LNG;

public class ParameterLoaderParser {
    static final String PARAMETER_LOADER_ELEMENT = "carregar_parametros";
    static final String INPUT_PARAMETER_ELEMENT = "parametro_de_entrada";
    private static final String PARAMETER_LOADER_ELEMENT_ALGORITHM_ATTRIBUTE = "algoritmo";
    private static final String PARAMETER_LOADER_ELEMENT_OUTPUT_ATTRIBUTE = "saida";
    private static final String PARAMETER_LOADER_ELEMENT_VERSION_ATTRIBUTE = "versao";
    private static final String PARAMETER_LOADER_ELEMENT_VALIDATION_ATTRIBUTE = "validar_entrada";
    private static final String INPUT_PARAMETER_ELEMENT_NAME_ATTRIBUTE = "nome";

    public void loadParameterLoader(XmlParser parser, ParameterGroup group) throws ParseException {
        String algorithmName = parser.extractAttributeValue(PARAMETER_LOADER_ELEMENT_ALGORITHM_ATTRIBUTE);
        String algorithmVersionIdStr = parser.extractAttributeValue(PARAMETER_LOADER_ELEMENT_VERSION_ATTRIBUTE);
        AlgorithmVersionId algorithmVersionId = AlgorithmVersionId.create(algorithmVersionIdStr);
        if (algorithmVersionId == null) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.InvalidAttributeVersion"), PARAMETER_LOADER_ELEMENT_VERSION_ATTRIBUTE, PARAMETER_LOADER_ELEMENT);
        }
        String outputParameterName = parser.extractAttributeValue(PARAMETER_LOADER_ELEMENT_OUTPUT_ATTRIBUTE);
        boolean validate_input = parser.extractAttributeValueAsBoolean(PARAMETER_LOADER_ELEMENT_VALIDATION_ATTRIBUTE, true);
        ParameterLoader parameterLoader = new ParameterLoader(algorithmName, algorithmVersionId, outputParameterName, validate_input);
        if (parser.goToFirstChild()) {
            do {
                parser.ensureElementName(INPUT_PARAMETER_ELEMENT);
                String inputParameterName = null;
                inputParameterName = parser.extractAttributeValue(INPUT_PARAMETER_ELEMENT_NAME_ATTRIBUTE);
                if (!parameterLoader.addInputParameterName(inputParameterName)) {
                    throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.ExistentParameter"), inputParameterName, INPUT_PARAMETER_ELEMENT);
                }
                parser.checkAttributes();
            } while (parser.goToNextSibling());
            parser.goToParent();
        }
        parser.checkAttributes();
        if (!group.setParameterLoader(parameterLoader)) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.ExistentParamLoader"), group);
        }
    }
}

