/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.IntegerStructureAttributes;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;

public class IntegerListParameterFactory
extends SimpleParameterParser<IntegerListParameter>
implements IntegerStructureAttributes {
    public static final String INTEGER_LIST_PARAMETER_ELEMENT = "lista_de_inteiros";

    @Override
    public IntegerListParameter createSimpleParameter(XmlParser parser, ParsedSimpleParameter definition, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Integer maximum = (Integer)definition.getAttributeValue("maximo");
        Integer minimum = (Integer)definition.getAttributeValue("minimo");
        return new IntegerListParameter(definition.getName(), definition.getLabel(), definition.getDescription(), null, definition.isOptional(), definition.isVisible(), definition.getCommandLinePattern(), maximum, minimum);
    }

    @Override
    public ParameterStructure<IntegerListParameter> getParameterStructure() {
        return this.getIntegerStructure(INTEGER_LIST_PARAMETER_ELEMENT, IntegerListParameter.class);
    }
}

