/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.elements;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.elements.IElementStructure;
import csbase.logic.algorithms.parsers.elements.attributes.IElementAttribute;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParsedElement
implements Serializable {
    private final Map<IElementAttribute<?>, Object> attributeValues;
    private final Map<IElementStructure<?>, List<ParsedElement>> children;
    private final String contentValue;

    public ParsedElement(Map<IElementAttribute<?>, Object> attributeValues, String contentValue) throws ParseException {
        this.attributeValues = attributeValues;
        this.children = new HashMap();
        this.contentValue = contentValue;
        this.checkValues();
    }

    public ParsedElement(Map<IElementAttribute<?>, Object> attributeValues, Map<IElementStructure<?>, List<ParsedElement>> children) throws ParseException {
        this.attributeValues = attributeValues;
        this.contentValue = null;
        this.children = children != null ? children : new HashMap();
        this.checkValues();
    }

    public String getContentValue() {
        return this.contentValue;
    }

    public void checkValues() throws ParseException {
        for (IElementAttribute<?> elementAttribute : this.getAttributes()) {
            elementAttribute.validate(this);
        }
    }

    public boolean hasChildren(String name) {
        IElementStructure<?> childElement = this.getChildElement(name);
        return childElement != null;
    }

    public List<ParsedElement> getChildren(String name) {
        IElementStructure<?> childElement = this.getChildElement(name);
        return this.children.get(childElement);
    }

    public <E> E getAttributeValue(String name) {
        IElementAttribute<?> elementAttribute = this.getAttribute(name);
        if (elementAttribute == null) {
            throw new IllegalArgumentException("Atributo " + name + " n\u00e3o definido ");
        }
        return (E)this.attributeValues.get(elementAttribute);
    }

    public IElementAttribute<?> getAttribute(String name) {
        for (IElementAttribute<?> elementAttribute : this.getAttributes()) {
            if (!elementAttribute.getName().equals(name)) continue;
            return elementAttribute;
        }
        return null;
    }

    private IElementStructure<?> getChildElement(String name) {
        for (IElementStructure<?> child : this.getChildren()) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public Set<IElementStructure<?>> getChildren() {
        return this.children.keySet();
    }

    public Set<IElementAttribute<?>> getAttributes() {
        return this.attributeValues.keySet();
    }

    public boolean hasAttributeValue(String name) {
        return this.getAttribute(name) != null;
    }
}

