/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.elements.attributes;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parsers.elements.attributes.AbstractElementAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.DoubleAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.IntegerAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringToValueConverter;

public class DerivedTypeAttribute
extends AbstractElementAttribute
implements StringToValueConverter<Object> {
    private final Parameter<?> parameter;

    DerivedTypeAttribute(String name, boolean optional, Object defaultValue, Parameter<?> parameter) {
        super(name, Object.class, optional, defaultValue, null);
        this.parameter = parameter;
    }

    public DerivedTypeAttribute(String name, Object defaultValue, Parameter<?> parameter) {
        this(name, true, defaultValue, parameter);
    }

    public DerivedTypeAttribute(String name, Parameter<?> parameter) {
        this(name, false, null, parameter);
    }

    @Override
    public StringToValueConverter<?> getValueConverter() {
        return this;
    }

    @Override
    public Object valueOf(String string) throws ParseException {
        if (this.parameter instanceof BooleanParameter) {
            BooleanAttribute booleanAttribute = new BooleanAttribute(this.getName(), this.isOptional(), (Boolean)this.getDefaultValue(), null);
            StringToValueConverter<Boolean> valueConverter = booleanAttribute.getValueConverter();
            return valueConverter.valueOf(string);
        }
        if (this.parameter instanceof TextParameter) {
            StringAttribute stringAttribute = new StringAttribute(this.getName(), this.isOptional(), (String)this.getDefaultValue(), null);
            StringToValueConverter<String> valueConverter = stringAttribute.getValueConverter();
            return valueConverter.valueOf(string);
        }
        if (this.parameter instanceof DoubleParameter) {
            DoubleAttribute attribute = new DoubleAttribute(this.getName(), this.isOptional(), (Double)this.getDefaultValue(), null, null, null, null, null);
            StringToValueConverter<Double> valueConverter = attribute.getValueConverter();
            return valueConverter.valueOf(string);
        }
        if (this.parameter instanceof IntegerParameter) {
            IntegerAttribute attribute = new IntegerAttribute(this.getName(), this.isOptional(), (Integer)this.getDefaultValue(), null, null, null, null, null);
            StringToValueConverter<Integer> valueConverter = attribute.getValueConverter();
            return valueConverter.valueOf(string);
        }
        if (this.parameter instanceof EnumerationParameter) {
            EnumerationParameter enumerationParameter = (EnumerationParameter)this.parameter;
            StringAttribute stringAttribute = new StringAttribute(this.getName());
            StringToValueConverter<String> valueConverter = stringAttribute.getValueConverter();
            String itemId = valueConverter.valueOf(string);
            EnumerationItem item = enumerationParameter.getItem(itemId);
            if (item == null) {
                throw new ParseException("O item {1} do par\u00e2metro {0} referenciado em uma condi\u00e7\u00e3o n\u00e3o foi definido.", this.parameter, itemId);
            }
            return item;
        }
        throw new ParseException("O par\u00e2metro {0} n\u00e3o \u00e9 aceito.\nApenas os tipos {1}, {2}, {3}, {4} e {5} s\u00e3o permitidos.", this.parameter, "booleano", "texto", "real", "inteiro", "enumeracao");
    }
}

