/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.triggers.AllowEditParameterTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.ChangeDefaultValueTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.ChangeFileTypeTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.ChangeLabelTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.ChangeMaximumTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.ChangeMinimumTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.DisableParameterTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.EnableParameterTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.HideEnumerationItemTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.HideGroupTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.HideParameterTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.ProhibitEditParameterTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.ShowEnumerationItemTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.ShowGroupTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.ShowParameterTriggerFactory;
import csbase.logic.algorithms.parsers.triggers.TriggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class TriggerParser {
    private Map<String, TriggerFactory> factoriesByElementName = new HashMap<String, TriggerFactory>();

    public TriggerParser() {
        this.addFactory(new EnableParameterTriggerFactory());
        this.addFactory(new DisableParameterTriggerFactory());
        this.addFactory(new ShowParameterTriggerFactory());
        this.addFactory(new HideParameterTriggerFactory());
        this.addFactory(new ShowGroupTriggerFactory());
        this.addFactory(new HideGroupTriggerFactory());
        this.addFactory(new ShowEnumerationItemTriggerFactory());
        this.addFactory(new HideEnumerationItemTriggerFactory());
        this.addFactory(new AllowEditParameterTriggerFactory());
        this.addFactory(new ProhibitEditParameterTriggerFactory());
        this.addFactory(new ChangeDefaultValueTriggerFactory());
        this.addFactory(new ChangeLabelTriggerFactory());
        this.addFactory(new ChangeMaximumTriggerFactory());
        this.addFactory(new ChangeMinimumTriggerFactory());
        this.addFactory(new ChangeFileTypeTriggerFactory());
    }

    public void loadTriggers(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        if (parser.goToFirstChild()) {
            do {
                Set<Trigger<?>> triggers = null;
                String elementName = parser.getElementName();
                TriggerFactory factory = this.getFactory(elementName);
                if (factory == null) continue;
                triggers = factory.createTriggers(parser, configurator);
                for (Trigger<?> trigger : triggers) {
                    if (configurator.addTrigger(trigger)) continue;
                    throw new ParseException("Foi encontrado um gatilho repetido no algoritmo {0}.\nGatilho repetido: {1}.\n", configurator, trigger);
                }
            } while (parser.goToNextSibling());
            parser.goToParent();
        }
    }

    TriggerFactory getFactory(String elementName) {
        return this.factoriesByElementName.get(elementName);
    }

    Set<TriggerFactory> getFactories() {
        HashSet<TriggerFactory> factories = new HashSet<TriggerFactory>();
        for (TriggerFactory factory : this.factoriesByElementName.values()) {
            factories.add(factory);
        }
        return Collections.unmodifiableSet(factories);
    }

    private void addFactory(TriggerFactory factory) {
        this.factoriesByElementName.put(factory.getElementName(), factory);
    }
}

