/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.console.AbstractConsoleApp;
import csbase.console.BasicParams;
import csbase.console.ExitCode;
import csbase.console.RemoveAlgoVersionParams;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.remote.ClientRemoteLocator;
import java.util.Arrays;
import java.util.List;

class RemoveAlgoVersion
extends AbstractConsoleApp {
    RemoveAlgoVersion(String[] args) {
        super(args);
    }

    @Override
    protected BasicParams createParams() {
        return new RemoveAlgoVersionParams();
    }

    @Override
    protected void postLoginInit() {
    }

    @Override
    protected boolean preLogout() {
        return true;
    }

    @Override
    public String getLogin() {
        RemoveAlgoVersionParams params = (RemoveAlgoVersionParams)this.getParams();
        String login = (String)(params.userLogin == null ? User.getAdminId() : params.userLogin);
        return login;
    }

    @Override
    public ExitCode execute() throws Exception {
        RemoveAlgoVersionParams params = (RemoveAlgoVersionParams)this.getParams();
        return RemoveAlgoVersion.startAlgorithmRemoval(params.algorithmId, params.versionId);
    }

    private static ExitCode startAlgorithmRemoval(String algorithmId, String versionId) throws Exception {
        AlgorithmInfo info = ClientRemoteLocator.algorithmService.getInfo((Object)algorithmId);
        if (info == null) {
            System.err.println("Id de algoritmo inv\u00e1lido.");
            return ExitCode.FAILURE;
        }
        List<Object> list = Arrays.asList(info.getVersionIds());
        for (Object obj : list) {
            if (!obj.toString().equalsIgnoreCase(versionId)) continue;
            ClientRemoteLocator.algorithmService.removeVersion((Object)algorithmId, (Object)AlgorithmVersionId.create((String)versionId));
            System.out.println("Vers\u00e3o " + versionId + " removida.");
            return ExitCode.SUCCESS;
        }
        System.err.println("Vers\u00e3o n\u00e3o encontrada.");
        return ExitCode.FAILURE;
    }
}

