/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.enterprisegrouprole.FindAllEnterpriseGroupRoleAuthorizationWithEnterpriseGroupCommand;
import br.com.petrobras.security.command.management.authorization.enterprisegrouprole.FindAllEnterpriseGroupRoleAuthorizationWithRoleCommand;
import br.com.petrobras.security.command.management.authorization.enterprisegrouprole.GrantRoleAuthorizationToEnterpriseGroupCommand;
import br.com.petrobras.security.command.management.authorization.enterprisegrouprole.RevokeRoleAuthorizationFromEnterpriseGroupCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IEnterpriseGroupRoleAuthorizationManager;
import br.com.petrobras.security.model.EnterpriseGroup;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.authorization.access.EnterpriseGroupRoleAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class EnterpriseGroupRoleAuthorizationManagerCoreImpl
implements IEnterpriseGroupRoleAuthorizationManager {
    public List<EnterpriseGroupRoleAuthorization> findAllWithEnterpriseGroup(EnterpriseGroup enterpriseGroup) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)enterpriseGroup);
        return this.findAllWithEnterpriseGroup(enterpriseGroup.getId());
    }

    public List<EnterpriseGroupRoleAuthorization> findAllWithEnterpriseGroup(String enterpriseGroupId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllEnterpriseGroupRoleAuthorizationWithEnterpriseGroupCommand cmd = ICommandIdentifier.getInstance().getFindAllEnterpriseGroupRoleAuthorizationWithEnterpriseGroupCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        return (List)cmd.execute();
    }

    public List<EnterpriseGroupRoleAuthorization> findAllWithRole(Role role) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        return this.findAllWithRole(role.getId());
    }

    public List<EnterpriseGroupRoleAuthorization> findAllWithRole(String roleId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllEnterpriseGroupRoleAuthorizationWithRoleCommand cmd = ICommandIdentifier.getInstance().getFindAllEnterpriseGroupRoleAuthorizationWithRoleCommand();
        cmd.setRoleIdArg(roleId);
        return (List)cmd.execute();
    }

    public void grant(EnterpriseGroup enterpriseGroup, Role role) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)enterpriseGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        this.grant(enterpriseGroup.getId(), role.getId());
    }

    public void grant(String enterpriseGroupId, String roleId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        GrantRoleAuthorizationToEnterpriseGroupCommand cmd = ICommandIdentifier.getInstance().getGrantRoleAuthorizationToEnterpriseGroupCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        cmd.setRoleIdArg(roleId);
        cmd.execute();
    }

    public void revoke(EnterpriseGroup enterpriseGroup, Role role) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)enterpriseGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        this.revoke(enterpriseGroup.getId(), role.getId());
    }

    public void revoke(String enterpriseGroupId, String roleId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        RevokeRoleAuthorizationFromEnterpriseGroupCommand cmd = ICommandIdentifier.getInstance().getRevokeRoleAuthorizationFromEnterpriseGroupCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        cmd.setRoleIdArg(roleId);
        cmd.execute();
    }
}

