/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.enterprise;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.enterprise.enterprisegroup.FindAllEnterpriseGroupMembershipCommand;
import br.com.petrobras.security.command.management.enterprise.enterprisegroup.FindAllEnterpriseGroupsCommand;
import br.com.petrobras.security.command.management.enterprise.enterprisegroup.FindAllEnterpriseGroupsOfUserCommand;
import br.com.petrobras.security.command.management.enterprise.enterprisegroup.FindEnterpriseGroupByIdCommand;
import br.com.petrobras.security.command.management.enterprise.enterprisegroup.FindEnterpriseGroupsByIdsCommand;
import br.com.petrobras.security.command.management.enterprise.enterprisegroup.RemoveEnterpriseGroupCommand;
import br.com.petrobras.security.command.management.enterprise.enterprisegroup.SaveEnterpriseGroupCommand;
import br.com.petrobras.security.command.management.enterprise.enterprisegroup.UpdateEnterpriseGroupCommand;
import br.com.petrobras.security.command.management.enterprise.enterprisegroup.VerifyEnterpriseGroupMembershipCommand;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.ConstraintViolationException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.enterprise.IEnterpriseGroupManager;
import br.com.petrobras.security.model.EnterpriseGroup;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class EnterpriseGroupManagerCoreImpl
implements IEnterpriseGroupManager {
    private IUserContextIdentifier userContextIdentifier;

    public IUserContextIdentifier getUserContextIdentifier() {
        return this.userContextIdentifier;
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public EnterpriseGroup find(String enterpriseGroupId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindEnterpriseGroupByIdCommand cmd = ICommandIdentifier.getInstance().getFindEnterpriseGroupByIdCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        return (EnterpriseGroup)cmd.execute();
    }

    public List<EnterpriseGroup> find(List<String> ids) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindEnterpriseGroupsByIdsCommand cmd = ICommandIdentifier.getInstance().getFindEnterpriseGroupsByIdsCommand();
        cmd.setEnterpriseGroupsIdsArg(ids);
        return (List)cmd.execute();
    }

    public List<EnterpriseGroup> findAll() throws PermissionDeniedException, SecurityException {
        FindAllEnterpriseGroupsCommand cmd = ICommandIdentifier.getInstance().getFindAllEnterpriseGroupsCommand();
        return (List)cmd.execute();
    }

    public void remove(EnterpriseGroup enterpriseGroup) throws InvalidArgumentException, PermissionDeniedException, InvalidOperationException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)enterpriseGroup);
        this.remove(enterpriseGroup.getId());
    }

    public void remove(String enterpriseGroupId) throws InvalidArgumentException, PermissionDeniedException, InvalidOperationException, ObjectNotFoundException, SecurityException {
        RemoveEnterpriseGroupCommand cmd = ICommandIdentifier.getInstance().getRemoveEnterpriseGroupCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        cmd.execute();
    }

    public void save(EnterpriseGroup enterpriseGroup) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, ConstraintViolationException, ObjectNotFoundException, SecurityException {
        SaveEnterpriseGroupCommand cmd = ICommandIdentifier.getInstance().getSaveEnterpriseGroupCommand();
        cmd.setEnterpriseGroupArg(enterpriseGroup);
        cmd.execute();
    }

    public void update(EnterpriseGroup enterpriseGroup) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, ConstraintViolationException, ObjectNotFoundException, SecurityException {
        UpdateEnterpriseGroupCommand cmd = ICommandIdentifier.getInstance().getUpdateEnterpriseGroupCommand();
        cmd.setEnterpriseGroupArg(enterpriseGroup);
        cmd.execute();
    }

    public void update(String oldId, EnterpriseGroup enterpriseGroup) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, ConstraintViolationException, ObjectNotFoundException, SecurityException {
        UpdateEnterpriseGroupCommand cmd = ICommandIdentifier.getInstance().getUpdateEnterpriseGroupCommand();
        cmd.setEnterpriseGroupArg(enterpriseGroup);
        cmd.setOldIdArg(oldId);
        cmd.execute();
    }

    public List<EnterpriseGroup> findAll(User user) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        return this.findAll(user.getLogin());
    }

    public List<EnterpriseGroup> findAll(String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllEnterpriseGroupsOfUserCommand cmd = ICommandIdentifier.getInstance().getFindAllEnterpriseGroupsOfUserCommand();
        cmd.setUserLoginArg(userLogin);
        return (List)cmd.execute();
    }

    public List<User> findAllMembers(String enterpriseGroupId, Long start, Long length) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllEnterpriseGroupMembershipCommand cmd = ICommandIdentifier.getInstance().getFindAllEnterpriseGroupMembershipCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        cmd.setStartArg(start);
        cmd.setLengthArg(length);
        return (List)cmd.execute();
    }

    public Boolean isMember(String enterpriseGroupId, String userLogin) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        VerifyEnterpriseGroupMembershipCommand cmd = ICommandIdentifier.getInstance().getVerifyEnterpriseGroupMembershipCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        cmd.setUserLoginArg(userLogin);
        return (Boolean)cmd.execute();
    }
}

