/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.enterprise;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.enterprise.function.FindAllFunctionsCommand;
import br.com.petrobras.security.command.management.enterprise.function.FindFunctionByCodeCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.enterprise.IFunctionManager;
import br.com.petrobras.security.model.Function;
import java.util.List;

public class FunctionManagerCoreImpl
implements IFunctionManager {
    public List<Function> findAll() throws PermissionDeniedException, SecurityException {
        FindAllFunctionsCommand cmd = ICommandIdentifier.getInstance().getFindAllFunctionsCommand();
        return (List)cmd.execute();
    }

    public Function find(Long functionCode) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindFunctionByCodeCommand cmd = ICommandIdentifier.getInstance().getFindFunctionByCodeCommand();
        cmd.setFunctionCodeArg(functionCode);
        return (Function)cmd.execute();
    }
}

