/*
 * ResourceGroupManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.access;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.access.IResourceGroupManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ResourceGroupMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.ResourceGroup;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * 
 * 
 * @author Eraldo Neto - HMGL
 * 
 */
public class ResourceGroupManagerConsumerSoapImpl implements
        IResourceGroupManagerConsumer {

    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Logging ] */

    private static final Logger LOGGER = Logger
            .getLogger(ResourceGroupManagerConsumerSoapImpl.class);

    /* [ Logging ] */

    /* [ Operators ] */

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.access.
     * IResourceGroupManagerConsumer
     * #find(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<ResourceGroup> find(MessageHeader messageHeader,
            String resourceGroupId) {

        LOGGER
                .info("Fazendo chamada para consulta de grupo de recursos a partir do ID usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findResourceGroupById(smh, resourceGroupId);

        // Converte o retorno.
        ReturnMessage<ResourceGroup> rm = ReturnMessageMounter
                .mountLocalObjectWithResourceGroupValue(rmDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        LOGGER
                .info("Chamada para para consulta de grupo de recursos a partir do ID usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.access.
     * IResourceGroupManagerConsumer
     * #find(br.com.petrobras.security.consume.MessageHeader, java.util.List)
     */
    public ReturnMessage<List<ResourceGroup>> find(MessageHeader messageHeader,
            List<String> resourceGroupIds) {

        LOGGER
                .info("Fazendo chamada para consulta de grupos de recursos a partir de IDs usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findResourceGroupsById(smh,
                        resourceGroupIds);

        // Converte o retorno.
        ReturnMessage<List<ResourceGroup>> rm = ReturnMessageMounter
                .mountLocalObjectWithResourceGroupListValue(rmDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        LOGGER
                .info("Chamada para para consulta de grupos de recursos a partir de IDs usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.access.
     * IResourceGroupManagerConsumer
     * #findAll(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<ResourceGroup>> findAll(
            MessageHeader messageHeader) {

        LOGGER
                .info("Fazendo chamada para consulta de todos os grupos de recursos usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllResourceGroups(smh);

        // Converte o retorno.
        ReturnMessage<List<ResourceGroup>> rm = ReturnMessageMounter
                .mountLocalObjectWithResourceGroupListValue(rmDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        LOGGER
                .info("Chamada para consulta de todos os grupos de recursos usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.access.
     * IResourceGroupManagerConsumer
     * #remove(br.com.petrobras.security.consume.MessageHeader,
     * java.lang.String)
     */
    public ReturnMessage<Boolean> remove(MessageHeader messageHeader,
            String resourceGroupId) {

        LOGGER
                .info("Fazendo chamada para remoo de grupo de recursos usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .removeResourceGroup(smh, resourceGroupId);

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER
                .info("Chamada para remoo de grupo de recursos usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.access.
     * IResourceGroupManagerConsumer
     * #save(br.com.petrobras.security.consume.MessageHeader,
     * br.com.petrobras.security.model.ResourceGroup)
     */
    public ReturnMessage<Boolean> save(MessageHeader messageHeader,
            ResourceGroup resourceGroup) {

        LOGGER
                .info("Fazendo chamada para incluso de grupo de recursos usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint()
                .saveResourceGroup(smh,
                        ResourceGroupMounter.mountTransferObject(resourceGroup));

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER
                .info("Chamada para incluso de grupo de recursos usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.access.
     * IResourceGroupManagerConsumer
     * #update(br.com.petrobras.security.consume.MessageHeader,
     * br.com.petrobras.security.model.ResourceGroup)
     */
    public ReturnMessage<Boolean> update(MessageHeader messageHeader,
            ResourceGroup resourceGroup) {

        LOGGER
                .info("Fazendo chamada para atualizao de grupo de recursos usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint()
                .updateResourceGroupWithUidLoaded(smh,
                        ResourceGroupMounter.mountTransferObject(resourceGroup));

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER
                .info("Chamada para atualizao de grupo de recursos usando consumidor de servio SOAP feita.");

        return rm;
    }

    /*
     * (non-Javadoc)
     * 
     * @seebr.com.petrobras.security.consume.management.access.
     * IResourceGroupManagerConsumer
     * #update(br.com.petrobras.security.consume.MessageHeader,
     * java.lang.String, br.com.petrobras.security.model.ResourceGroup)
     */
    public ReturnMessage<Boolean> update(MessageHeader messageHeader,
            String oldId, ResourceGroup resourceGroup) {

        LOGGER
                .info("Fazendo chamada para atualizao de grupo de recursos usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint()
                .updateResourceGroup(smh, oldId,
                        ResourceGroupMounter.mountTransferObject(resourceGroup));

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER
                .info("Chamada para atualizao de grupo de recursos usando consumidor de servio SOAP feita.");

        return rm;
    }

    /* [ Operators ] */
}
