package br.com.petrobras.security.consume.soap.management.basic;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.basic.IUserGroupMembershipManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.model.UserGroupMembership;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

/**
 * Implementao SOAP do consumidor de gerenciamento de autorizaes de
 * usurio em grupo.
 * 
 * @author UPM7
 *
 */
public class UserGroupMembershipManagerConsumerSoapImpl implements
        IUserGroupMembershipManagerConsumer {

/* [ Constantes ] */
    
    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }
    
    
    
    public ReturnMessage<Boolean> addUserToGroup(MessageHeader mh,
            String userLogin, String userGroupId) { 
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().addUserToGroup(smhDTO, userLogin, userGroupId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
        
    }

    public ReturnMessage<Boolean> removeUserFromGroup(
            MessageHeader mh, String userLogin, String userGroupId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().removeUserFromGroup(smhDTO, userLogin, userGroupId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    public ReturnMessage<Boolean> addUsersListToGroup(MessageHeader messageHeader, List<String> usersLogins, String userGroupId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().addUsersListToGroup(smhDTO, usersLogins, userGroupId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    public ReturnMessage<Boolean> removeUsersListFromGroup(MessageHeader messageHeader, List<String> usersLogins, String userGroupId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().removeUsersListFromGroup(smhDTO, usersLogins, userGroupId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    public ReturnMessage<List<UserGroupMembership>> findAllUserGroupsOfUser(MessageHeader mh,
            String userLogin) throws ObjectNotFoundException {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllUserGroupsAuthorizationsOfUser(smhDTO, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserGroupAuthorizationListValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }
    
    public ReturnMessage<List<UserGroupMembership>> findAllUserGroupAuthorizationsOfUserGroupId(MessageHeader mh,
            String userGroupId) throws ObjectNotFoundException {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllUsersAuthorizationsOfUserGroup(smhDTO, userGroupId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserGroupAuthorizationListValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    public ReturnMessage<Boolean> isMember(MessageHeader messageHeader,
            String userGroupId, String userLogin)
            throws ObjectNotFoundException {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().isUserGroupMembership(smhDTO, userGroupId, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }
    
}
